/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matcher
extends ContextAwareBase
implements LifeCycle {
    private String regex;
    private String name;
    private boolean caseSensitive = true;
    private boolean canonEq = false;
    private boolean unicodeCase = false;
    private boolean start = false;
    private Pattern pattern;

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    @Override
    public void start() {
        if (this.name == null) {
            this.addError("All Matcher objects must be named");
            return;
        }
        try {
            int n = 0;
            if (!this.caseSensitive) {
                n = 2;
            }
            if (this.canonEq) {
                n |= 0x80;
            }
            if (this.unicodeCase) {
                n |= 0x40;
            }
            this.pattern = Pattern.compile(this.regex, n);
            this.start = true;
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Matcher matcher = this;
            matcher.addError("Failed to compile regex [" + matcher.regex + "]", patternSyntaxException);
            return;
        }
    }

    @Override
    public void stop() {
        this.start = false;
    }

    @Override
    public boolean isStarted() {
        return this.start;
    }

    public boolean matches(String object) {
        if (this.start) {
            object = this.pattern.matcher((CharSequence)object);
            return ((java.util.regex.Matcher)object).find();
        }
        throw new EvaluationException("Matcher [" + this.regex + "] not started");
    }

    public boolean isCanonEq() {
        return this.canonEq;
    }

    public void setCanonEq(boolean bl) {
        this.canonEq = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isUnicodeCase() {
        return this.unicodeCase;
    }

    public void setUnicodeCase(boolean bl) {
        this.unicodeCase = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

