/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionInvokeDescriptor;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.GivenFunctionsMemberScope;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class FunctionClassScope
extends GivenFunctionsMemberScope {
    public FunctionClassScope(StorageManager storageManager, FunctionClassDescriptor functionClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)functionClassDescriptor, (String)"");
        super(storageManager, functionClassDescriptor);
    }

    @Override
    protected final List<FunctionDescriptor> computeDeclaredFunctions() {
        ClassDescriptor classDescriptor = this.getContainingClass();
        Intrinsics.checkNotNull((Object)classDescriptor);
        FunctionTypeKind functionTypeKind = ((FunctionClassDescriptor)classDescriptor).getFunctionTypeKind();
        if (Intrinsics.areEqual((Object)functionTypeKind, (Object)FunctionTypeKind.Function.INSTANCE)) {
            return CollectionsKt.listOf((Object)FunctionInvokeDescriptor.Factory.create((FunctionClassDescriptor)this.getContainingClass(), false));
        }
        if (Intrinsics.areEqual((Object)functionTypeKind, (Object)FunctionTypeKind.SuspendFunction.INSTANCE)) {
            return CollectionsKt.listOf((Object)FunctionInvokeDescriptor.Factory.create((FunctionClassDescriptor)this.getContainingClass(), true));
        }
        return CollectionsKt.emptyList();
    }
}

