/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;

public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeParameter,
DefinitelyNotNullTypeMarker {
    public static final Companion Companion = new Companion(null);
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;

    private DefinitelyNotNullType(SimpleType simpleType, boolean bl) {
        this.original = simpleType;
        this.useCorrectedNullabilityForTypeParameters = bl;
    }

    public final SimpleType getOriginal() {
        return this.original;
    }

    @Override
    protected final SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public final boolean isMarkedNullable() {
        return false;
    }

    @Override
    public final boolean isTypeParameter() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    public final KotlinType substitutionResult(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(kotlinType.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    public final SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return new DefinitelyNotNullType(this.getDelegate().replaceAttributes(typeAttributes), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    public final SimpleType makeNullableAsSpecified(boolean bl) {
        if (bl) {
            return this.getDelegate().makeNullableAsSpecified(bl);
        }
        return this;
    }

    @Override
    public final String toString() {
        return this.getDelegate() + " & Any";
    }

    @Override
    public final DefinitelyNotNullType replaceDelegate(SimpleType simpleType) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        return new DefinitelyNotNullType(simpleType, this.useCorrectedNullabilityForTypeParameters);
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType simpleType, boolean bl, DefaultConstructorMarker defaultConstructorMarker) {
        this(simpleType, bl);
    }

    public static final class Companion {
        private Companion() {
        }

        public final DefinitelyNotNullType makeDefinitelyNotNull(UnwrappedType object, boolean bl, boolean bl2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            if (object instanceof DefinitelyNotNullType) {
                return (DefinitelyNotNullType)object;
            }
            if (bl2 || this.makesSenseToBeDefinitelyNotNull((UnwrappedType)object, bl)) {
                if (object instanceof FlexibleType) {
                    bl2 = Intrinsics.areEqual((Object)((FlexibleType)object).getLowerBound().getConstructor(), (Object)((FlexibleType)object).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl2) {
                        object = "DefinitelyNotNullType for flexible type (" + object + ") can be created only from type variable with the same constructor for bounds";
                        throw new AssertionError(object);
                    }
                }
                return new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible((KotlinType)object).makeNullableAsSpecified(false), bl, null);
            }
            return null;
        }

        public static /* synthetic */ DefinitelyNotNullType makeDefinitelyNotNull$default(Companion companion, UnwrappedType unwrappedType, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.makeDefinitelyNotNull(unwrappedType, bl, bl2);
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType unwrappedType, boolean bl) {
            if (!this.canHaveUndefinedNullability(unwrappedType)) {
                return false;
            }
            if (unwrappedType instanceof StubTypeForBuilderInference) {
                return TypeUtils.isNullableType(unwrappedType);
            }
            ClassifierDescriptor classifierDescriptor = unwrappedType.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
            boolean bl2 = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
            if (bl2) {
                return true;
            }
            if (bl && unwrappedType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(unwrappedType);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(unwrappedType);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType unwrappedType) {
            return unwrappedType.getConstructor() instanceof NewTypeVariableConstructor || unwrappedType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || unwrappedType instanceof NewCapturedType || unwrappedType instanceof StubTypeForBuilderInference;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

