/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class FlexibleTypeWithEnhancement
extends FlexibleType
implements TypeWithEnhancement {
    private final FlexibleType origin;
    private final KotlinType enhancement;

    public FlexibleTypeWithEnhancement(FlexibleType flexibleType, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        super(flexibleType.getLowerBound(), flexibleType.getUpperBound());
        this.origin = flexibleType;
        this.enhancement = kotlinType;
    }

    @Override
    public final FlexibleType getOrigin() {
        return this.origin;
    }

    @Override
    public final KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    public final UnwrappedType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(typeAttributes), this.getEnhancement());
    }

    @Override
    public final UnwrappedType makeNullableAsSpecified(boolean bl) {
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(bl), this.getEnhancement().unwrap().makeNullableAsSpecified(bl));
    }

    @Override
    public final String render(DescriptorRenderer descriptorRenderer, DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        if (descriptorRendererOptions.getEnhancedTypes()) {
            return descriptorRenderer.renderType(this.getEnhancement());
        }
        return this.getOrigin().render(descriptorRenderer, descriptorRendererOptions);
    }

    @Override
    public final SimpleType getDelegate() {
        return this.getOrigin().getDelegate();
    }

    @Override
    public final FlexibleTypeWithEnhancement refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getOrigin());
        Intrinsics.checkNotNull((Object)kotlinType);
        return new FlexibleTypeWithEnhancement((FlexibleType)kotlinType, kotlinTypeRefiner.refineType(this.getEnhancement()));
    }

    @Override
    public final String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

