/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.internal.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DomainWildcardMappingBuilder<V> {
    private final V defaultValue;
    private final Map<String, V> map;

    public DomainWildcardMappingBuilder(V v) {
        this(4, v);
    }

    public DomainWildcardMappingBuilder(int n, V v) {
        this.defaultValue = ObjectUtil.checkNotNull(v, "defaultValue");
        this.map = new LinkedHashMap<String, V>(n);
    }

    public DomainWildcardMappingBuilder<V> add(String string, V v) {
        this.map.put(this.normalizeHostName(string), ObjectUtil.checkNotNull(v, "output"));
        return this;
    }

    private String normalizeHostName(String string) {
        ObjectUtil.checkNotNull(string, "hostname");
        if (string.isEmpty() || string.charAt(0) == '.') {
            throw new IllegalArgumentException("Hostname '" + string + "' not valid");
        }
        if ((string = ImmutableDomainWildcardMapping.normalize(ObjectUtil.checkNotNull(string, "hostname"))).charAt(0) == '*') {
            if (string.length() < 3 || string.charAt(1) != '.') {
                throw new IllegalArgumentException("Wildcard Hostname '" + string + "'not valid");
            }
            return string.substring(1);
        }
        return string;
    }

    public Mapping<String, V> build() {
        return new ImmutableDomainWildcardMapping<V>(this.defaultValue, this.map);
    }

    private static final class ImmutableDomainWildcardMapping<V>
    implements Mapping<String, V> {
        private static final String REPR_HEADER = "ImmutableDomainWildcardMapping(default: ";
        private static final String REPR_MAP_OPENING = ", map: ";
        private static final String REPR_MAP_CLOSING = ")";
        private final V defaultValue;
        private final Map<String, V> map;

        ImmutableDomainWildcardMapping(V v, Map<String, V> map) {
            this.defaultValue = v;
            this.map = new LinkedHashMap<String, V>(map);
        }

        @Override
        public final V map(String string) {
            if (string != null) {
                V v;
                V v2 = this.map.get(string = ImmutableDomainWildcardMapping.normalize(string));
                if (v2 != null) {
                    return v2;
                }
                int n = string.indexOf(46);
                if (n != -1 && (v = this.map.get(string.substring(n))) != null) {
                    return v;
                }
            }
            return this.defaultValue;
        }

        static String normalize(String string) {
            return DomainNameMapping.normalizeHostname(string);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(REPR_HEADER).append(this.defaultValue).append(", map: {");
            for (Map.Entry<String, V> entry : this.map.entrySet()) {
                String string = entry.getKey();
                if (string.charAt(0) == '.') {
                    string = "*" + string;
                }
                stringBuilder.append(string).append('=').append(entry.getValue()).append(", ");
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - 2);
            return stringBuilder.append('}').append(REPR_MAP_CLOSING).toString();
        }
    }
}

