/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.PromiseTask;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V>,
PriorityQueueNode {
    private long id;
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l;
        this.periodNanos = 0L;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l2);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l2);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l;
        this.periodNanos = 0L;
    }

    private static long validatePeriod(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        return l;
    }

    final ScheduledFutureTask<V> setId(long l) {
        if (this.id == 0L) {
            this.id = l;
        }
        return this;
    }

    @Override
    protected final EventExecutor executor() {
        return super.executor();
    }

    public final long deadlineNanos() {
        return this.deadlineNanos;
    }

    final void setConsumed() {
        if (this.periodNanos == 0L) {
            assert (this.scheduledExecutor().getCurrentTimeNanos() >= this.deadlineNanos);
            this.deadlineNanos = 0L;
        }
    }

    public final long delayNanos() {
        if (this.deadlineNanos == 0L) {
            return 0L;
        }
        ScheduledFutureTask scheduledFutureTask = this;
        return scheduledFutureTask.delayNanos(scheduledFutureTask.scheduledExecutor().getCurrentTimeNanos());
    }

    static long deadlineToDelayNanos(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return Math.max(0L, l2 - l);
    }

    public final long delayNanos(long l) {
        return ScheduledFutureTask.deadlineToDelayNanos(l, this.deadlineNanos);
    }

    @Override
    public final long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public final int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        delayed = (ScheduledFutureTask)delayed;
        long l = this.deadlineNanos() - ((ScheduledFutureTask)delayed).deadlineNanos();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        if (this.id < ((ScheduledFutureTask)delayed).id) {
            return -1;
        }
        assert (this.id != ((ScheduledFutureTask)delayed).id);
        return 1;
    }

    @Override
    public final void run() {
        assert (this.executor().inEventLoop());
        try {
            block10: {
                block9: {
                    block8: {
                        if (this.delayNanos() > 0L) {
                            if (this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().removeTyped(this);
                                return;
                            }
                            this.scheduledExecutor().scheduleFromEventLoop(this);
                            return;
                        }
                        if (this.periodNanos != 0L) break block8;
                        if (!this.setUncancellableInternal()) break block9;
                        break block10;
                    }
                    if (!this.isCancelled()) {
                        this.runTask();
                        if (!this.executor().isShutdown()) {
                            this.deadlineNanos = this.periodNanos > 0L ? (this.deadlineNanos += this.periodNanos) : this.scheduledExecutor().getCurrentTimeNanos() - this.periodNanos;
                            if (!this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().add(this);
                            }
                        }
                    }
                }
                return;
            }
            Object v = this.runTask();
            this.setSuccessInternal(v);
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    private AbstractScheduledEventExecutor scheduledExecutor() {
        return (AbstractScheduledEventExecutor)this.executor();
    }

    @Override
    public final boolean cancel(boolean bl) {
        if (bl = super.cancel(bl)) {
            this.scheduledExecutor().removeScheduled(this);
        }
        return bl;
    }

    final boolean cancelWithoutRemove(boolean bl) {
        return super.cancel(bl);
    }

    @Override
    protected final StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }

    @Override
    public final int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
        return this.queueIndex;
    }

    @Override
    public final void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n) {
        this.queueIndex = n;
    }
}

