/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Method ALLOCATE_ARRAY_METHOD;
    private static final Method ALIGN_SLICE;
    private static final int JAVA_VERSION;
    private static final boolean IS_ANDROID;
    private static final boolean STORE_FENCE_AVAILABLE;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final Object INTERNAL_UNSAFE;
    private static final boolean RUNNING_IN_NATIVE_IMAGE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    static final Unsafe UNSAFE;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    static final int HASH_CODE_C1 = -862048943;
    static final int HASH_CODE_C2 = 461845907;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;
    private static final long BITS_MAX_DIRECT_MEMORY;

    private static boolean unsafeStaticFieldOffsetSupported() {
        return !RUNNING_IN_NATIVE_IMAGE;
    }

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean bl = SystemPropertyUtil.getBoolean("io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl);
        String string = SystemPropertyUtil.get("sun.misc.unsafe.memory.access", "<unspecified>");
        if (!"allow".equals(string) && !"<unspecified>".equals(string)) {
            logger.debug("--sun-misc-unsafe-memory-access={}", (Object)string);
            bl = true;
        }
        if (bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String string2 = SystemPropertyUtil.contains("io.netty.tryUnsafe") ? "io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(string2, true)) {
            string2 = "sun.misc.Unsafe: unavailable (" + string2 + ")";
            logger.debug(string2);
            return new UnsupportedOperationException(string2);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static long bitsMaxDirectMemory() {
        return BITS_MAX_DIRECT_MEMORY;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n), n);
    }

    static ByteBuffer allocateDirectNoCleaner(int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, n)), n);
    }

    static boolean hasAlignSliceMethod() {
        return ALIGN_SLICE != null;
    }

    static ByteBuffer alignSlice(ByteBuffer byteBuffer, int n) {
        try {
            return (ByteBuffer)ALIGN_SLICE.invoke((Object)byteBuffer, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    static byte[] allocateUninitializedArray(int n) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invoke(INTERNAL_UNSAFE, Byte.TYPE, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static ByteBuffer newDirectBuffer(long l, int n) {
        ObjectUtil.checkPositiveOrZero(n, "capacity");
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l, n);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Error) {
                throw (Error)throwable2;
            }
            throw new Error(throwable2);
        }
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l) {
        return UNSAFE.getObject(object, l);
    }

    static int getInt(Object object, long l) {
        return UNSAFE.getInt(object, l);
    }

    static void safeConstructPutInt(Object object, long l, int n) {
        if (STORE_FENCE_AVAILABLE) {
            UNSAFE.putInt(object, l, n);
            UNSAFE.storeFence();
            return;
        }
        UNSAFE.putIntVolatile(object, l, n);
    }

    private static long getLong(Object object, long l) {
        return UNSAFE.getLong(object, l);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l) {
        return UNSAFE.getByte(l);
    }

    static short getShort(long l) {
        return UNSAFE.getShort(l);
    }

    static int getInt(long l) {
        return UNSAFE.getInt(l);
    }

    static long getLong(long l) {
        return UNSAFE.getLong(l);
    }

    static byte getByte(byte[] byArray, int n) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static byte getByte(byte[] byArray, long l) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l);
    }

    static short getShort(byte[] byArray, int n) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static int getInt(byte[] byArray, int n) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static int getInt(int[] nArray, long l) {
        return UNSAFE.getInt(nArray, INT_ARRAY_BASE_OFFSET + INT_ARRAY_INDEX_SCALE * l);
    }

    static int getIntVolatile(long l) {
        return UNSAFE.getIntVolatile(null, l);
    }

    static void putIntOrdered(long l, int n) {
        UNSAFE.putOrderedInt(null, l, n);
    }

    static long getLong(byte[] byArray, int n) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static long getLong(long[] lArray, long l) {
        return UNSAFE.getLong(lArray, LONG_ARRAY_BASE_OFFSET + LONG_ARRAY_INDEX_SCALE * l);
    }

    static void putByte(long l, byte by) {
        UNSAFE.putByte(l, by);
    }

    static void putShort(long l, short s) {
        UNSAFE.putShort(l, s);
    }

    static void putInt(long l, int n) {
        UNSAFE.putInt(l, n);
    }

    static void putLong(long l, long l2) {
        UNSAFE.putLong(l, l2);
    }

    static void putByte(byte[] byArray, int n, byte by) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, by);
    }

    static void putByte(Object object, long l, byte by) {
        UNSAFE.putByte(object, l, by);
    }

    static void putShort(byte[] byArray, int n, short s) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, s);
    }

    static void putInt(byte[] byArray, int n, int n2) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, n2);
    }

    static void putLong(byte[] byArray, int n, long l) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l);
    }

    static void putObject(Object object, long l, Object object2) {
        UNSAFE.putObject(object, l, object2);
    }

    static void copyMemory(long l, long l2, long l3) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(l, l2, l3);
            return;
        }
        UNSAFE.copyMemory(l, l2, l3);
    }

    private static void copyMemoryWithSafePointPolling(long l, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(l, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void copyMemory(Object object, long l, Object object2, long l2, long l3) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(object, l, object2, l2, l3);
            return;
        }
        UNSAFE.copyMemory(object, l, object2, l2, l3);
    }

    private static void copyMemoryWithSafePointPolling(Object object, long l, Object object2, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(object, l, object2, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void setMemory(long l, long l2, byte by) {
        UNSAFE.setMemory(l, l2, by);
    }

    static void setMemory(Object object, long l, long l2, byte by) {
        UNSAFE.setMemory(object, l, l2, by);
    }

    static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l;
        int n4 = n3 & 7;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l3 = n2 - n;
        if (n3 >= 8) {
            l = l2 + (long)n4;
            for (long i = l2 - 8L + (long)n3; i >= l; i -= 8L) {
                if (UNSAFE.getLong(byArray, i) == UNSAFE.getLong(byArray2, i + l3)) continue;
                return false;
            }
        }
        if (n4 >= 4 && UNSAFE.getInt(byArray, l = l2 + (long)(n4 -= 4)) != UNSAFE.getInt(byArray2, l + l3)) {
            return false;
        }
        l = l2 + l3;
        if (n4 >= 2) {
            return UNSAFE.getChar(byArray, l2) == UNSAFE.getChar(byArray2, l) && (n4 == 2 || UNSAFE.getByte(byArray, l2 + 2L) == UNSAFE.getByte(byArray2, l + 2L));
        }
        return n4 == 0 || UNSAFE.getByte(byArray, l2) == UNSAFE.getByte(byArray2, l);
    }

    static int equalsConstantTime(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l;
        long l2 = 0L;
        long l3 = n3 & 7;
        long l4 = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l5 = l4 + l3;
        long l6 = n2 - n;
        for (l = l4 - 8L + (long)n3; l >= l5; l -= 8L) {
            l2 |= UNSAFE.getLong(byArray, l) ^ UNSAFE.getLong(byArray2, l + l6);
        }
        if (l3 >= 4L) {
            l2 |= (long)(UNSAFE.getInt(byArray, l4) ^ UNSAFE.getInt(byArray2, l4 + l6));
            l3 -= 4L;
        }
        if (l3 >= 2L) {
            l = l5 - l3;
            l2 |= (long)(UNSAFE.getChar(byArray, l) ^ UNSAFE.getChar(byArray2, l + l6));
            l3 -= 2L;
        }
        if (l3 == 1L) {
            l = l5 - 1L;
            l2 |= (long)(UNSAFE.getByte(byArray, l) ^ UNSAFE.getByte(byArray2, l + l6));
        }
        return ConstantTimeUtils.equalsConstantTime(l2, 0L);
    }

    static boolean isZero(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return true;
        }
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        int n3 = n2 & 7;
        long l2 = l + (long)n3;
        for (long i = l - 8L + (long)n2; i >= l2; i -= 8L) {
            if (UNSAFE.getLong(byArray, i) == 0L) continue;
            return false;
        }
        if (n3 >= 4 && UNSAFE.getInt(byArray, l + (long)(n3 -= 4)) != 0) {
            return false;
        }
        if (n3 >= 2) {
            return UNSAFE.getChar(byArray, l) == '\u0000' && (n3 == 2 || byArray[n + 2] == 0);
        }
        return byArray[n] == 0;
    }

    static int hashCodeAscii(byte[] byArray, int n, int n2) {
        int n3 = -1028477387;
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        n = n2 & 7;
        long l2 = l + (long)n;
        for (long i = l - 8L + (long)n2; i >= l2; i -= 8L) {
            n3 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i), n3);
        }
        if (n == 0) {
            return n3;
        }
        int n4 = -862048943;
        if (n != 2 & n != 4 & n != 6) {
            n3 = n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l));
            n4 = 461845907;
            ++l;
        }
        if (n != 1 & n != 4 & n != 5) {
            n3 = n3 * n4 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l));
            n4 = n4 == -862048943 ? 461845907 : -862048943;
            l += 2L;
        }
        if (n >= 4) {
            return n3 * n4 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l));
        }
        return n3;
    }

    static int hashCodeAsciiCompute(long l, int n) {
        return n * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)l) * 461845907 + (int)((l & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n) {
        return n & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s) {
        return s & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by) {
        return by & 0x1F;
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long l) {
        return UNSAFE.allocateMemory(l);
    }

    static void freeMemory(long l) {
        UNSAFE.freeMemory(l);
    }

    static long reallocateMemory(long l, long l2) {
        return UNSAFE.reallocateMemory(l, l2);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    private static boolean isAndroid0() {
        String string = SystemPropertyUtil.get("java.vm.name");
        boolean bl = "Dalvik".equals(string);
        if (bl) {
            logger.debug("Platform: Android");
        }
        return bl;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9 || RUNNING_IN_NATIVE_IMAGE);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int n = PlatformDependent0.isAndroid0() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n);
        return n;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    static int majorVersion(String stringArray) {
        stringArray = stringArray.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private PlatformDependent0() {
    }

    static {
        Object object;
        Unsafe unsafe;
        Object object2;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        IS_ANDROID = PlatformDependent0.isAndroid0();
        RUNNING_IN_NATIVE_IMAGE = SystemPropertyUtil.contains("org.graalvm.nativeimage.imagecode");
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        boolean bl = false;
        Object object6 = EXPLICIT_NO_UNSAFE_CAUSE;
        if (object6 != null) {
            object2 = null;
            object3 = null;
            unsafe = null;
            object5 = null;
        } else {
            long l;
            Object object7;
            Unsafe unsafe2;
            object2 = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public final Object run() {
                    try {
                        Field field = Unsafe.class.getDeclaredField("theUnsafe");
                        Throwable throwable = ReflectionUtil.trySetAccessible(field, false);
                        if (throwable != null) {
                            return throwable;
                        }
                        return field.get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                        return noSuchFieldException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        NoClassDefFoundError noClassDefFoundError2 = noClassDefFoundError;
                        return noClassDefFoundError;
                    }
                }
            });
            if (object instanceof Throwable) {
                unsafe = null;
                object6 = (Throwable)object;
                if (logger.isTraceEnabled()) {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)object);
                } else {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable: {}", (Object)((Throwable)object).getMessage());
                }
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object7 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            Class<?> clazz = unsafe2.getClass();
                            clazz.getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                            if (PlatformDependent0.javaVersion() > 23) {
                                clazz.getDeclaredMethod("objectFieldOffset", Field.class);
                                clazz.getDeclaredMethod("staticFieldOffset", Field.class);
                                clazz.getDeclaredMethod("staticFieldBase", Field.class);
                                clazz.getDeclaredMethod("arrayBaseOffset", Class.class);
                                clazz.getDeclaredMethod("arrayIndexScale", Class.class);
                                clazz.getDeclaredMethod("allocateMemory", Long.TYPE);
                                clazz.getDeclaredMethod("reallocateMemory", Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("freeMemory", Long.TYPE);
                                clazz.getDeclaredMethod("setMemory", Long.TYPE, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("setMemory", Object.class, Long.TYPE, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("getBoolean", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getByte", Long.TYPE);
                                clazz.getDeclaredMethod("getByte", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getInt", Long.TYPE);
                                clazz.getDeclaredMethod("getInt", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getLong", Long.TYPE);
                                clazz.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("putByte", Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("putInt", Long.TYPE, Integer.TYPE);
                                clazz.getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                                clazz.getDeclaredMethod("putLong", Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("addressSize", new Class[0]);
                            }
                            if (PlatformDependent0.javaVersion() >= 23) {
                                long l = unsafe2.allocateMemory(8L);
                                unsafe2.putLong(l, 42L);
                                unsafe2.freeMemory(l);
                            }
                            return null;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
                            return unsupportedOperationException;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object7 == null) {
                    logger.debug("sun.misc.Unsafe base methods: all available");
                } else {
                    unsafe = null;
                    object6 = (Throwable)object7;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe method unavailable:", (Throwable)object6);
                    } else {
                        logger.debug("sun.misc.Unsafe method unavailable: {}", (Object)((Throwable)object7).getMessage());
                    }
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object7 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            unsafe2.getClass().getDeclaredMethod("storeFence", new Class[0]);
                            return null;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object7 == null) {
                    logger.debug("sun.misc.Unsafe.storeFence: available");
                    bl = true;
                } else {
                    bl = false;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe.storeFence: unavailable", (Throwable)object7);
                    } else {
                        logger.debug("sun.misc.Unsafe.storeFence: unavailable: {}", (Object)((Throwable)object7).getMessage());
                    }
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object7 = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                    final /* synthetic */ ByteBuffer val$direct;
                    {
                        this.val$direct = byteBuffer;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Field field = Buffer.class.getDeclaredField("address");
                            long l = unsafe2.objectFieldOffset(field);
                            long l2 = unsafe2.getLong(this.val$direct, l);
                            if (l2 == 0L) {
                                return null;
                            }
                            return field;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                            return noSuchFieldException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object7 instanceof Field) {
                    object3 = (Field)object7;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    object6 = (Throwable)object7;
                    if (logger.isTraceEnabled()) {
                        logger.debug("java.nio.Buffer.address: unavailable", (Throwable)object7);
                    } else {
                        logger.debug("java.nio.Buffer.address: unavailable: {}", (Object)((Throwable)object7).getMessage());
                    }
                    unsafe = null;
                }
            }
            if (unsafe != null && (l = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)l);
                object6 = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = object6;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_INDEX_SCALE = -1L;
            INT_ARRAY_BASE_OFFSET = -1L;
            INT_ARRAY_INDEX_SCALE = -1L;
            UNALIGNED = false;
            BITS_MAX_DIRECT_MEMORY = -1L;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
            STORE_FENCE_AVAILABLE = false;
        } else {
            boolean bl2;
            long l = -1L;
            try {
                object2 = AccessController.doPrivileged(new PrivilegedAction<Object>((ByteBuffer)object2){
                    final /* synthetic */ ByteBuffer val$direct;
                    {
                        this.val$direct = byteBuffer;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Constructor<?> constructor = PlatformDependent0.javaVersion() >= 21 ? this.val$direct.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE) : this.val$direct.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                            Throwable throwable = ReflectionUtil.trySetAccessible(constructor, true);
                            if (throwable != null) {
                                return throwable;
                            }
                            return constructor;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (object2 instanceof Constructor) {
                    l = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)object2).newInstance(l, 1);
                        object = (Constructor)object2;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        object = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = null;
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.debug("direct buffer constructor: unavailable", (Throwable)object2);
                    } else {
                        logger.debug("direct buffer constructor: unavailable: {}", (Object)((Throwable)object2).getMessage());
                    }
                    object = null;
                }
            }
            finally {
                if (l != -1L) {
                    UNSAFE.freeMemory(l);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset((Field)object3);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            INT_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
            LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            LONG_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
            object3 = new AtomicLong(-1L);
            object6 = AccessController.doPrivileged(new PrivilegedAction<Object>((AtomicLong)object3){
                final /* synthetic */ AtomicLong val$maybeMaxMemory;
                {
                    this.val$maybeMaxMemory = atomicLong;
                }

                @Override
                public final Object run() {
                    try {
                        Object object;
                        Object object2;
                        Class<?> clazz = Class.forName("java.nio.Bits", false, PlatformDependent0.getSystemClassLoader());
                        int n = PlatformDependent0.javaVersion();
                        if (PlatformDependent0.unsafeStaticFieldOffsetSupported() && n >= 9) {
                            long l;
                            object2 = n >= 11 ? "MAX_MEMORY" : "maxMemory";
                            try {
                                object = clazz.getDeclaredField((String)object2);
                                if (((Field)object).getType() == Long.TYPE) {
                                    l = UNSAFE.staticFieldOffset((Field)object);
                                    object2 = UNSAFE.staticFieldBase((Field)object);
                                    this.val$maybeMaxMemory.lazySet(UNSAFE.getLong(object2, l));
                                }
                            }
                            catch (Throwable throwable) {}
                            object2 = n >= 11 ? "UNALIGNED" : "unaligned";
                            try {
                                object = clazz.getDeclaredField((String)object2);
                                if (((Field)object).getType() == Boolean.TYPE) {
                                    l = UNSAFE.staticFieldOffset((Field)object);
                                    object2 = UNSAFE.staticFieldBase((Field)object);
                                    return UNSAFE.getBoolean(object2, l);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {}
                        }
                        if ((object = ReflectionUtil.trySetAccessible((AccessibleObject)(object2 = clazz.getDeclaredMethod("unaligned", new Class[0])), true)) != null) {
                            return object;
                        }
                        return ((Method)object2).invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                        return noSuchMethodException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        return classNotFoundException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InvocationTargetException invocationTargetException2 = invocationTargetException;
                        return invocationTargetException;
                    }
                }
            });
            if (object6 instanceof Boolean) {
                bl2 = (Boolean)object6;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl2);
            } else {
                object2 = SystemPropertyUtil.get("os.arch", "");
                bl2 = ((String)object2).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object6 = (Throwable)object6;
                if (logger.isTraceEnabled()) {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}", (Object)bl2, object6);
                } else {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}, {}", (Object)bl2, (Object)((Throwable)object6).getMessage());
                }
            }
            UNALIGNED = bl2;
            long l2 = BITS_MAX_DIRECT_MEMORY = ((AtomicLong)object3).get() >= 0L ? ((AtomicLong)object3).get() : -1L;
            if (PlatformDependent0.javaVersion() >= 9) {
                Object object8 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            GenericDeclaration genericDeclaration = PlatformDependent0.getClassLoader(PlatformDependent0.class).loadClass("jdk.internal.misc.Unsafe");
                            genericDeclaration = genericDeclaration.getDeclaredMethod("getUnsafe", new Class[0]);
                            return ((Method)genericDeclaration).invoke(null, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            return throwable;
                        }
                    }
                });
                if (!(object8 instanceof Throwable) && (object8 = AccessController.doPrivileged(new PrivilegedAction<Object>(object6 = (object5 = object8)){
                    final /* synthetic */ Object val$finalInternalUnsafe;
                    {
                        this.val$finalInternalUnsafe = object;
                    }

                    @Override
                    public final Object run() {
                        try {
                            return this.val$finalInternalUnsafe.getClass().getDeclaredMethod("allocateUninitializedArray", Class.class, Integer.TYPE);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                })) instanceof Method) {
                    try {
                        object3 = (Method)object8;
                        object6 = (byte[])((Method)object3).invoke(object6, Byte.TYPE, 8);
                        assert (((Object)object6).length == 8);
                        object4 = object3;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object3 = illegalAccessException;
                        object8 = illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object3 = invocationTargetException;
                        object8 = invocationTargetException;
                    }
                }
                if (object8 instanceof Throwable) {
                    if (logger.isTraceEnabled()) {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)object8);
                    } else {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable: {}", (Object)((Throwable)object8).getMessage());
                    }
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = object4;
            STORE_FENCE_AVAILABLE = bl;
        }
        ALIGN_SLICE = PlatformDependent0.javaVersion() > 9 ? (Method)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public final Object run() {
                try {
                    return ByteBuffer.class.getDeclaredMethod("alignedSlice", Integer.TYPE);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }) : null;
        INTERNAL_UNSAFE = object5;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, {int,long}): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

