/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.cipher.CipherKt;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a?\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "Lio/ktor/network/tls/TLSRecordType;", "recordType", "", "recordLength", "", "recordIv", "recordId", "Ljavax/crypto/Cipher;", "gcmEncryptCipher", "(Lio/ktor/network/tls/CipherSuite;[BLio/ktor/network/tls/TLSRecordType;IJJ)Ljavax/crypto/Cipher;", "gcmDecryptCipher", "ktor-network-tls"})
public final class GCMCipherKt {
    private static final Cipher gcmEncryptCipher(CipherSuite object, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        Cipher cipher = Cipher.getInstance(((CipherSuite)object).getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec secretKeySpec = KeysKt.clientKey(byArray, (CipherSuite)object);
        byArray = KeysKt.clientIV(byArray, (CipherSuite)object);
        byte[] byArray2 = Arrays.copyOf(byArray, ((CipherSuite)object).getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        byArray = byArray2;
        CipherKt.set(byArray2, ((CipherSuite)object).getFixedIvLength(), l2);
        object = new GCMParameterSpec(((CipherSuite)object).getCipherTagSizeInBytes() << 3, byArray);
        cipher2.init(1, (Key)secretKeySpec, (AlgorithmParameterSpec)object);
        byte[] byArray3 = new byte[13];
        object = byArray3;
        byArray = byArray3;
        CipherKt.set(byArray3, 0, l3);
        byArray[8] = (byte)tLSRecordType.getCode();
        byArray[9] = 3;
        byArray[10] = 3;
        CipherKt.set(byArray, 11, (short)n2);
        cipher2.updateAAD((byte[])object);
        return cipher2;
    }

    private static final Cipher gcmDecryptCipher(CipherSuite cipherSuite, byte[] object, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        Cipher cipher = Cipher.getInstance(cipherSuite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher);
        Cipher cipher2 = cipher;
        SecretKeySpec secretKeySpec = KeysKt.serverKey((byte[])object, cipherSuite);
        object = KeysKt.serverIV((byte[])object, cipherSuite);
        byte[] byArray = Arrays.copyOf((byte[])object, cipherSuite.getIvLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        object = byArray;
        CipherKt.set(byArray, cipherSuite.getFixedIvLength(), l2);
        object = new GCMParameterSpec(cipherSuite.getCipherTagSizeInBytes() << 3, (byte[])object);
        cipher2.init(2, (Key)secretKeySpec, (AlgorithmParameterSpec)object);
        int n3 = n2 - (cipherSuite.getIvLength() - cipherSuite.getFixedIvLength()) - cipherSuite.getCipherTagSizeInBytes();
        if (!(n3 < 65536)) {
            object = "Content size should fit in 2 bytes, actual: " + n3;
            throw new IllegalStateException(object.toString());
        }
        object = new byte[13];
        byte[] byArray2 = object;
        CipherKt.set((byte[])object, 0, l3);
        byArray2[8] = (byte)tLSRecordType.getCode();
        byArray2[9] = 3;
        byArray2[10] = 3;
        CipherKt.set(byArray2, 11, (short)n3);
        Object object2 = object;
        cipher2.updateAAD((byte[])object2);
        return cipher2;
    }

    public static final /* synthetic */ Cipher access$gcmEncryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        return GCMCipherKt.gcmEncryptCipher(cipherSuite, byArray, tLSRecordType, n2, l2, l3);
    }

    public static final /* synthetic */ Cipher access$gcmDecryptCipher(CipherSuite cipherSuite, byte[] byArray, TLSRecordType tLSRecordType, int n2, long l2, long l3) {
        return GCMCipherKt.gcmDecryptCipher(cipherSuite, byArray, tLSRecordType, n2, l2, l3);
    }
}

