/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SubMenuUsabilityHelper
implements ChangeListener {
    private static final String KEY_USE_SAFE_TRIANGLE = "Menu.useSafeTriangle";
    private static final String KEY_SHOW_SAFE_TRIANGLE = "FlatLaf.debug.menu.showSafeTriangle";
    private static SubMenuUsabilityHelper instance;
    private SubMenuEventQueue subMenuEventQueue;
    private SafeTrianglePainter safeTrianglePainter;
    private boolean changePending;
    private int mouseX;
    private int mouseY;
    private int targetX;
    private int targetTopY;
    private int targetBottomY;
    private Rectangle invokerBounds;

    SubMenuUsabilityHelper() {
    }

    static synchronized boolean install() {
        if (instance != null) {
            return false;
        }
        instance = new SubMenuUsabilityHelper();
        MenuSelectionManager.defaultManager().addChangeListener(instance);
        return true;
    }

    static synchronized void uninstall() {
        if (instance == null) {
            return;
        }
        MenuSelectionManager.defaultManager().removeChangeListener(instance);
        instance.uninstallEventQueue();
        instance = null;
    }

    @Override
    public void stateChanged(ChangeEvent object) {
        if (!FlatUIUtils.getUIBoolean(KEY_USE_SAFE_TRIANGLE, true)) {
            return;
        }
        object = this;
        synchronized (object) {
            if (this.changePending) {
                return;
            }
            this.changePending = true;
        }
        EventQueue.invokeLater(() -> {
            SubMenuUsabilityHelper subMenuUsabilityHelper = this;
            synchronized (subMenuUsabilityHelper) {
                this.changePending = false;
            }
            this.menuSelectionChanged();
        });
    }

    private void menuSelectionChanged() {
        Object object = MenuSelectionManager.defaultManager().getSelectedPath();
        int n = this.findSubMenu((MenuElement[])object);
        if (n < 0 || n != ((MenuElement[])object).length - 1) {
            this.uninstallEventQueue();
            return;
        }
        Object object2 = MouseInfo.getPointerInfo();
        object2 = object2 != null ? ((PointerInfo)object2).getLocation() : new Point();
        this.mouseX = ((Point)object2).x;
        this.mouseY = ((Point)object2).y;
        if (!((Component)(object = (JPopupMenu)object[n])).isShowing()) {
            this.uninstallEventQueue();
            return;
        }
        Serializable serializable = ((JPopupMenu)object).getInvoker();
        Rectangle rectangle = this.invokerBounds = serializable != null && serializable.isShowing() ? new Rectangle(serializable.getLocationOnScreen(), serializable.getSize()) : null;
        if (this.invokerBounds != null && !this.invokerBounds.contains(this.mouseX, this.mouseY)) {
            this.uninstallEventQueue();
            return;
        }
        serializable = ((Component)object).getLocationOnScreen();
        object2 = ((Component)object).getSize();
        this.targetX = this.mouseX < ((Point)serializable).x + ((Dimension)object2).width / 2 ? ((Point)serializable).x : ((Point)serializable).x + ((Dimension)object2).width;
        this.targetTopY = ((Point)serializable).y;
        this.targetBottomY = ((Point)serializable).y + ((Dimension)object2).height;
        if (this.subMenuEventQueue == null) {
            this.subMenuEventQueue = new SubMenuEventQueue();
        }
        if (this.safeTrianglePainter == null && UIManager.getBoolean(KEY_SHOW_SAFE_TRIANGLE)) {
            this.safeTrianglePainter = new SafeTrianglePainter((JPopupMenu)object);
        }
    }

    private void uninstallEventQueue() {
        if (this.subMenuEventQueue != null) {
            this.subMenuEventQueue.uninstall();
            this.subMenuEventQueue = null;
        }
        if (this.safeTrianglePainter != null) {
            this.safeTrianglePainter.uninstall();
            this.safeTrianglePainter = null;
        }
    }

    private int findSubMenu(MenuElement[] menuElementArray) {
        for (int i = menuElementArray.length - 1; i > 0; --i) {
            if (!(menuElementArray[i] instanceof JPopupMenu) || !(menuElementArray[i - 1] instanceof JMenu) || ((JMenu)menuElementArray[i - 1]).isTopLevelMenu()) continue;
            return i;
        }
        return -1;
    }

    private Polygon createSafeTriangle() {
        return new Polygon(new int[]{this.mouseX, this.targetX, this.targetX}, new int[]{this.mouseY, this.targetTopY, this.targetBottomY}, 3);
    }

    private class SafeTrianglePainter
    extends JComponent {
        SafeTrianglePainter(JPopupMenu jPopupMenu) {
            SubMenuUsabilityHelper.this = SwingUtilities.windowForComponent(jPopupMenu.getInvoker());
            if (SubMenuUsabilityHelper.this instanceof RootPaneContainer) {
                SubMenuUsabilityHelper.this = ((RootPaneContainer)SubMenuUsabilityHelper.this).getLayeredPane();
                this.setSize(((Component)SubMenuUsabilityHelper.this).getSize());
                ((Container)SubMenuUsabilityHelper.this).add((Component)this, (Object)(JLayeredPane.POPUP_LAYER + 1));
            }
        }

        void uninstall() {
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
                container.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Point point = this.getLocationOnScreen();
            graphics.translate(-point.x, -point.y);
            graphics.setColor(Color.red);
            ((Graphics2D)graphics).draw(SubMenuUsabilityHelper.this.createSafeTriangle());
        }
    }

    private class SubMenuEventQueue
    extends EventQueue {
        private Timer mouseUpdateTimer = new Timer(50, actionEvent -> {
            SubMenuUsabilityHelper.this.mouseX = this.newMouseX;
            SubMenuUsabilityHelper.this.mouseY = this.newMouseY;
            if (SubMenuUsabilityHelper.this.safeTrianglePainter != null) {
                SubMenuUsabilityHelper.this.safeTrianglePainter.repaint();
            }
        });
        private Timer timeoutTimer;
        private int newMouseX;
        private int newMouseY;
        private AWTEvent lastMouseEvent;

        SubMenuEventQueue() {
            this.mouseUpdateTimer.setRepeats(false);
            this.timeoutTimer = new Timer(200, actionEvent -> {
                if (SubMenuUsabilityHelper.this.invokerBounds != null && !SubMenuUsabilityHelper.this.invokerBounds.contains(this.newMouseX, this.newMouseY)) {
                    if (this.lastMouseEvent != null) {
                        SubMenuEventQueue subMenuEventQueue = this;
                        subMenuEventQueue.postEvent(subMenuEventQueue.lastMouseEvent);
                        this.lastMouseEvent = null;
                    }
                    SubMenuUsabilityHelper.this.uninstallEventQueue();
                    return;
                }
            });
            this.timeoutTimer.setRepeats(false);
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
        }

        void uninstall() {
            this.mouseUpdateTimer.stop();
            this.mouseUpdateTimer = null;
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
            this.lastMouseEvent = null;
            super.pop();
        }

        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            int n = aWTEvent.getID();
            if (aWTEvent instanceof MouseEvent && (n == 503 || n == 506)) {
                this.newMouseX = ((MouseEvent)aWTEvent).getXOnScreen();
                this.newMouseY = ((MouseEvent)aWTEvent).getYOnScreen();
                if (SubMenuUsabilityHelper.this.safeTrianglePainter != null) {
                    SubMenuUsabilityHelper.this.safeTrianglePainter.repaint();
                }
                this.mouseUpdateTimer.stop();
                this.timeoutTimer.stop();
                if (SubMenuUsabilityHelper.this.createSafeTriangle().contains(this.newMouseX, this.newMouseY)) {
                    this.mouseUpdateTimer.start();
                    this.timeoutTimer.start();
                    this.lastMouseEvent = aWTEvent;
                    return;
                }
                SubMenuUsabilityHelper.this.mouseX = this.newMouseX;
                SubMenuUsabilityHelper.this.mouseY = this.newMouseY;
            }
            super.dispatchEvent(aWTEvent);
        }
    }
}

