/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;

public class HiDPIUtils {
    private static Boolean useTextYCorrection;
    private static final float[] SCALE_FACTORS;
    private static final float[] CORRECTION_SEGOE_UI;
    private static final float[] CORRECTION_TAHOMA;
    private static final float[] CORRECTION_INTER;
    private static final float[] CORRECTION_OPEN_SANS;
    private static Boolean useDebugScaleFactor;

    public static void paintAtScale1x(Graphics2D graphics2D, JComponent jComponent, Painter painter) {
        HiDPIUtils.paintAtScale1x(graphics2D, 0, 0, jComponent.getWidth(), jComponent.getHeight(), painter);
    }

    public static void paintAtScale1x(Graphics2D graphics2D, int n, int n2, int n3, int n4, Painter painter) {
        double d;
        double d2;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d3 = affineTransform.getScaleX();
        double d4 = affineTransform.getScaleY();
        double d5 = affineTransform.getShearX();
        double d6 = affineTransform.getShearY();
        boolean bl = d5 != 0.0 || d6 != 0.0 || d3 <= 0.0 || d4 <= 0.0;
        if (bl) {
            d2 = Math.hypot(d3, d5);
            d = Math.hypot(d4, d6);
        } else {
            d2 = Math.abs(d3);
            d = Math.abs(d4);
        }
        if (d2 == 1.0 && d == 1.0) {
            painter.paint(graphics2D, n, n2, n3, n4, 1.0);
            return;
        }
        double d7 = (double)n * d3 + (double)n2 * d5 + affineTransform.getTranslateX();
        double d8 = (double)n2 * d4 + (double)n * d6 + affineTransform.getTranslateY();
        Rectangle2D.Double double_ = HiDPIUtils.scale(d2, d, d7, d8, n3, n4);
        try {
            AffineTransform affineTransform2;
            if (bl) {
                affineTransform2 = new AffineTransform(d3, d6, d5, d4, Math.floor(double_.x), Math.floor(double_.y));
                affineTransform2.scale(1.0 / d2, 1.0 / d);
            } else {
                affineTransform2 = new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(double_.x), Math.floor(double_.y));
            }
            graphics2D.setTransform(affineTransform2);
            int n5 = (int)double_.width;
            int n6 = (int)double_.height;
            painter.paint(graphics2D, 0, 0, n5, n6, d2);
            return;
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    private static Rectangle2D.Double scale(double d, double d2, double d3, double d4, int n, int n2) {
        double d5 = HiDPIUtils.normalize(d3);
        double d6 = HiDPIUtils.normalize(d4);
        double d7 = HiDPIUtils.normalize(d3 + (double)n * d) - d5;
        double d8 = HiDPIUtils.normalize(d4 + (double)n2 * d2) - d6;
        return new Rectangle2D.Double(d5, d6, d7, d8);
    }

    private static double normalize(double d) {
        return Math.floor(d + 0.25) + 0.25;
    }

    private static boolean useTextYCorrection() {
        if (useTextYCorrection == null) {
            useTextYCorrection = FlatSystemProperties.getBoolean("flatlaf.useTextYCorrection", true);
        }
        return useTextYCorrection;
    }

    public static float computeTextYCorrection(Graphics2D graphics2D) {
        if (!HiDPIUtils.useTextYCorrection() || !SystemInfo.isWindows) {
            return 0.0f;
        }
        if (!SystemInfo.isJava_9_orLater) {
            float f;
            float f2 = HiDPIUtils.getUserScaleFactor();
            if (f > 1.0f) {
                switch (graphics2D.getFont().getFamily()) {
                    case "Segoe UI": 
                    case "Segoe UI Light": 
                    case "Segoe UI Semibold": {
                        return -((f2 == 2.25f || f2 == 4.0f ? 0.875f : 0.625f) * f2);
                    }
                    case "Noto Sans": 
                    case "Open Sans": {
                        return -(0.3f * f2);
                    }
                    case "Verdana": {
                        return -((f2 < 2.0f ? 0.4f : 0.3f) * f2);
                    }
                }
            }
        } else {
            switch (graphics2D.getFont().getFamily()) {
                case "Segoe UI": 
                case "Segoe UI Light": 
                case "Segoe UI Semibold": 
                case "Verdana": 
                case "Dialog": 
                case "SansSerif": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_SEGOE_UI);
                }
                case "Tahoma": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_TAHOMA);
                }
                case "Inter": 
                case "Inter Light": 
                case "Inter Semi Bold": 
                case "Inter SemiBold": 
                case "Roboto": 
                case "Roboto Light": 
                case "Roboto Medium": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_INTER);
                }
                case "Noto Sans": 
                case "Open Sans": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_OPEN_SANS);
                }
            }
        }
        return 0.0f;
    }

    private static float correctionForScaleY(Graphics2D graphics2D, float[] fArray) {
        double d;
        if (fArray.length != 9) {
            throw new IllegalArgumentException();
        }
        double d2 = graphics2D.getTransform().getScaleY();
        if (d < 1.25) {
            return 0.0f;
        }
        return fArray[HiDPIUtils.scaleFactor2index((float)d2)];
    }

    private static int scaleFactor2index(float f) {
        for (int i = 0; i < SCALE_FACTORS.length; ++i) {
            if (!(f <= SCALE_FACTORS[i])) continue;
            return i;
        }
        return SCALE_FACTORS.length - 1;
    }

    private static boolean useDebugScaleFactor() {
        if (useDebugScaleFactor == null) {
            useDebugScaleFactor = FlatSystemProperties.getBoolean("FlatLaf.debug.HiDPIUtils.useDebugScaleFactor", false);
        }
        return useDebugScaleFactor;
    }

    private static float getUserScaleFactor() {
        if (!HiDPIUtils.useDebugScaleFactor()) {
            return UIScale.getUserScaleFactor();
        }
        return Float.parseFloat(System.getProperty("FlatLaf.debug.HiDPIUtils.debugScaleFactor", "1"));
    }

    public static void drawStringWithYCorrection(JComponent jComponent, Graphics2D graphics2D, String string, int n, int n2) {
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(jComponent, graphics2D, string, -1, n, n2);
    }

    public static void drawStringUnderlineCharAtWithYCorrection(JComponent jComponent, Graphics2D graphics2D, String string, int n, int n2, int n3) {
        float f = HiDPIUtils.computeTextYCorrection(graphics2D);
        if (f != 0.0f) {
            graphics2D.translate(0.0, f);
            JavaCompatibility.drawStringUnderlineCharAt(jComponent, graphics2D, string, n, n2, n3);
            graphics2D.translate(0.0, -f);
            return;
        }
        JavaCompatibility.drawStringUnderlineCharAt(jComponent, graphics2D, string, n, n2, n3);
    }

    public static Graphics2D createGraphicsTextYCorrection(Graphics2D graphics2D) {
        final float f = HiDPIUtils.computeTextYCorrection(graphics2D);
        if (f == 0.0f) {
            return graphics2D;
        }
        return new Graphics2DProxy(graphics2D){

            @Override
            public void drawString(String string, int n, int n2) {
                super.drawString(string, (float)n, (float)n2 + f);
            }

            @Override
            public void drawString(String string, float f3, float f2) {
                super.drawString(string, f3, f2 + f);
            }

            @Override
            public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
                super.drawString(attributedCharacterIterator, (float)n, (float)n2 + f);
            }

            @Override
            public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f3, float f2) {
                super.drawString(attributedCharacterIterator, f3, f2 + f);
            }

            @Override
            public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
                super.drawChars(cArray, n, n2, n3, Math.round((float)n4 + f));
            }

            @Override
            public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
                super.drawBytes(byArray, n, n2, n3, Math.round((float)n4 + f));
            }

            @Override
            public void drawGlyphVector(GlyphVector glyphVector, float f3, float f2) {
                super.drawGlyphVector(glyphVector, f3, f2 + f);
            }
        };
    }

    static {
        SCALE_FACTORS = new float[]{1.25f, 1.5f, 1.75f, 2.0f, 2.25f, 2.5f, 3.0f, 3.5f, 4.0f};
        CORRECTION_SEGOE_UI = new float[]{-0.5f, -0.5f, -0.625f, -0.75f, -0.75f, -0.75f, -0.75f, -0.75f, -0.875f};
        CORRECTION_TAHOMA = new float[]{-0.25f, -0.25f, -0.25f, 0.0f, -0.125f, -0.125f, -0.125f, -0.125f, 0.0f};
        CORRECTION_INTER = new float[]{-0.25f, -0.25f, -0.25f, 0.0f, -0.125f, -0.125f, 0.0f, -0.25f, 0.0f};
        CORRECTION_OPEN_SANS = new float[]{-0.5f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f};
    }

    public static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);
    }
}

