/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatFileViewDirectoryIcon;
import com.formdev.flatlaf.ui.JavaCompatibility2;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.ScaledImageIcon;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellRenderer;

public class FlatFileChooserUI
extends MetalFileChooserUI {
    private final FlatFileView fileView = new FlatFileView();
    private FlatShortcutsPanel shortcutsPanel;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatFileChooserUI((JFileChooser)jComponent);
    }

    public FlatFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        FlatShortcutsPanel flatShortcutsPanel;
        super.installComponents(jFileChooser);
        this.patchUI(jFileChooser);
        if (!UIManager.getBoolean("FileChooser.noPlacesBar") && (flatShortcutsPanel = this.createShortcutsPanel(jFileChooser)).getComponentCount() > 0) {
            this.shortcutsPanel = flatShortcutsPanel;
            jFileChooser.add((Component)this.shortcutsPanel, "Before");
            jFileChooser.addPropertyChangeListener(this.shortcutsPanel);
        }
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        super.uninstallComponents(jFileChooser);
        if (this.shortcutsPanel != null) {
            jFileChooser.removePropertyChangeListener(this.shortcutsPanel);
            this.shortcutsPanel = null;
        }
    }

    private void patchUI(JFileChooser jFileChooser) {
        Component component;
        Component component2;
        Component[] componentArray;
        Object object;
        Component component3 = jFileChooser.getComponent(0);
        if (component3 instanceof JPanel && ((JPanel)component3).getLayout() instanceof BorderLayout && (object = ((JPanel)component3).getComponent(0)) instanceof JPanel && ((JPanel)object).getLayout() instanceof BoxLayout) {
            Insets insets = UIManager.getInsets("Button.margin");
            componentArray = ((JPanel)object).getComponents();
            for (int i = componentArray.length - 1; i >= 0; --i) {
                component2 = componentArray[i];
                if (component2 instanceof JButton || component2 instanceof JToggleButton) {
                    component = (AbstractButton)component2;
                    ((JComponent)component).putClientProperty("JButton.buttonType", "toolBarButton");
                    ((AbstractButton)component).setMargin(insets);
                    component.setFocusable(false);
                    continue;
                }
                if (!(component2 instanceof Box.Filler)) continue;
                ((JPanel)object).remove(i);
            }
        }
        try {
            int n;
            object = ((JPanel)component3).getComponent(2);
            if (object instanceof JComboBox && (n = UIManager.getInt("ComboBox.maximumRowCount")) > 0) {
                ((JComboBox)object).setMaximumRowCount(n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        object = jFileChooser.getLayout();
        if (object instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)object;
            borderLayout.setHgap(8);
            componentArray = borderLayout.getLayoutComponent("North");
            Component component4 = borderLayout.getLayoutComponent("After");
            component2 = borderLayout.getLayoutComponent("Center");
            component = borderLayout.getLayoutComponent("South");
            if (componentArray != null && component4 != null && component2 != null && component != null) {
                component3 = new JPanel(new BorderLayout(0, 11));
                ((Container)component3).add((Component)componentArray, "North");
                ((Container)component3).add(component4, "After");
                ((Container)component3).add(component2, "Center");
                ((Container)component3).add(component, "South");
                jFileChooser.add(component3, "Center");
            }
        }
    }

    @Override
    protected JPanel createDetailsView(JFileChooser jComponent) {
        jComponent = super.createDetailsView((JFileChooser)jComponent);
        if (!SystemInfo.isWindows) {
            return jComponent;
        }
        JScrollPane jScrollPane = null;
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)component;
            break;
        }
        if (jScrollPane == null) {
            return jComponent;
        }
        Component component = jScrollPane.getViewport().getView();
        if (!(component instanceof JTable)) {
            return jComponent;
        }
        JTable jTable = (JTable)component;
        final TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(Object.class);
        jTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object instanceof String && ((String)object).startsWith("\u200e")) {
                    object = (String)object;
                    char[] cArray = new char[((String)object).length()];
                    int n3 = 0;
                    for (int i = 0; i < cArray.length; ++i) {
                        char c = ((String)object).charAt(i);
                        if (c == '\u200e' || c == '\u200f') continue;
                        cArray[n3++] = c;
                    }
                    object = new String(cArray, 0, n3);
                }
                return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        return jComponent;
    }

    protected FlatShortcutsPanel createShortcutsPanel(JFileChooser jFileChooser) {
        return new FlatShortcutsPanel(jFileChooser);
    }

    @Override
    public Dimension getPreferredSize(JComponent serializable) {
        Dimension dimension = super.getPreferredSize((JComponent)serializable);
        serializable = this.getMinimumSize((JComponent)serializable);
        int n = this.shortcutsPanel != null ? this.shortcutsPanel.getPreferredSize().width : 0;
        return new Dimension(Math.max(dimension.width, ((Dimension)serializable).width + n), Math.max(dimension.height, ((Dimension)serializable).height));
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return UIScale.scale(super.getMinimumSize(jComponent));
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        if (FlatFileChooserUI.doNotUseSystemIcons()) {
            return super.getFileView(jFileChooser);
        }
        return this.fileView;
    }

    @Override
    public void clearIconCache() {
        if (FlatFileChooserUI.doNotUseSystemIcons()) {
            super.clearIconCache();
            return;
        }
        this.fileView.clearIconCache();
    }

    private static boolean doNotUseSystemIcons() {
        return SystemInfo.isWindows && SystemInfo.isX86 && SystemInfo.isJava_17_orLater && SystemInfo.javaVersion < SystemInfo.toVersion(17, 0, 3, 0);
    }

    private static class ShortcutIcon
    implements Icon {
        private final Icon icon;
        private final int iconWidth;
        private final int iconHeight;

        ShortcutIcon(Icon icon, int n, int n2) {
            this.icon = icon;
            this.iconWidth = n;
            this.iconHeight = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics = (Graphics2D)graphics.create();
            try {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                double d = (double)this.getIconWidth() / (double)this.icon.getIconWidth();
                ((Graphics2D)graphics).translate(n, n2);
                double d2 = d;
                ((Graphics2D)graphics).scale(d2, d2);
                this.icon.paintIcon(component, graphics, 0, 0);
                return;
            }
            finally {
                graphics.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return UIScale.scale(this.iconWidth);
        }

        @Override
        public int getIconHeight() {
            return UIScale.scale(this.iconHeight);
        }
    }

    public static class FlatShortcutsPanel
    extends JToolBar
    implements PropertyChangeListener {
        private final JFileChooser fc;
        private final Dimension buttonSize;
        private final Dimension iconSize;
        private final Function<File[], File[]> filesFunction;
        private final Function<File, String> displayNameFunction;
        private final Function<File, Icon> iconFunction;
        protected final File[] files;
        protected final JToggleButton[] buttons;
        protected final ButtonGroup buttonGroup = new ButtonGroup();

        public FlatShortcutsPanel(JFileChooser jFileChooser) {
            super(1);
            this.fc = jFileChooser;
            this.setFloatable(false);
            this.buttonSize = UIScale.scale(this.getUIDimension("FileChooser.shortcuts.buttonSize", 84, 64));
            this.iconSize = this.getUIDimension("FileChooser.shortcuts.iconSize", 32, 32);
            this.filesFunction = (Function)UIManager.get("FileChooser.shortcuts.filesFunction");
            this.displayNameFunction = (Function)UIManager.get("FileChooser.shortcuts.displayNameFunction");
            this.iconFunction = (Function)UIManager.get("FileChooser.shortcuts.iconFunction");
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            File[] fileArray = JavaCompatibility2.getChooserShortcutPanelFiles(fileSystemView);
            if (this.filesFunction != null) {
                fileArray = this.filesFunction.apply(fileArray);
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (File file : fileArray) {
                if (file == null) continue;
                if (fileSystemView.isFileSystemRoot(file)) {
                    file = fileSystemView.createFileObject(file.getAbsolutePath());
                }
                Object object = this.getDisplayName(fileSystemView, file);
                Object object2 = this.getIcon(fileSystemView, file);
                if (object == null) continue;
                int n = ((String)object).lastIndexOf(File.separatorChar);
                if (n >= 0 && n < ((String)object).length() - 1) {
                    object = ((String)object).substring(n + 1);
                }
                if (object2 instanceof ImageIcon) {
                    object2 = new ScaledImageIcon((ImageIcon)object2, this.iconSize.width, this.iconSize.height);
                } else if (object2 != null) {
                    object2 = new ShortcutIcon((Icon)object2, this.iconSize.width, this.iconSize.height);
                }
                object = this.createButton((String)object, (Icon)object2);
                object2 = file;
                ((AbstractButton)object).addActionListener(arg_0 -> FlatShortcutsPanel.lambda$new$0(jFileChooser, (File)object2, arg_0));
                this.add((Component)object);
                this.buttonGroup.add((AbstractButton)object);
                arrayList.add(file);
                arrayList2.add(object);
            }
            ArrayList<File> arrayList3 = arrayList;
            this.files = arrayList3.toArray(new File[arrayList3.size()]);
            ArrayList<Object> arrayList4 = arrayList2;
            this.buttons = arrayList4.toArray(new JToggleButton[arrayList4.size()]);
            this.directoryChanged(jFileChooser.getCurrentDirectory());
        }

        private Dimension getUIDimension(String object, int n, int n2) {
            if ((object = UIManager.getDimension(object)) == null) {
                object = new Dimension(n, n2);
            }
            return object;
        }

        protected JToggleButton createButton(String object, Icon icon) {
            object = new JToggleButton((String)object, icon);
            ((AbstractButton)object).setVerticalTextPosition(3);
            ((AbstractButton)object).setHorizontalTextPosition(0);
            ((JComponent)object).setAlignmentX(0.5f);
            ((AbstractButton)object).setIconTextGap(0);
            ((JComponent)object).setPreferredSize(this.buttonSize);
            ((JComponent)object).setMaximumSize(this.buttonSize);
            return object;
        }

        protected String getDisplayName(FileSystemView fileSystemView, File file) {
            String string;
            if (this.displayNameFunction != null && (string = this.displayNameFunction.apply(file)) != null) {
                return string;
            }
            return fileSystemView.getSystemDisplayName(file);
        }

        protected Icon getIcon(FileSystemView fileSystemView, File file) {
            Object object;
            if (this.iconFunction != null && (object = this.iconFunction.apply(file)) != null) {
                return object;
            }
            if (FlatFileChooserUI.doNotUseSystemIcons()) {
                return new FlatFileViewDirectoryIcon();
            }
            try {
                block9: {
                    try {
                        if (SystemInfo.isJava_17_orLater) {
                            object = fileSystemView.getClass().getMethod("getSystemIcon", File.class, Integer.TYPE, Integer.TYPE);
                            return (Icon)((Method)object).invoke((Object)fileSystemView, file, this.iconSize.width, this.iconSize.height);
                        }
                        if ((this.iconSize.width > 16 || this.iconSize.height > 16) && ((Class)(object = Class.forName("sun.awt.shell.ShellFolder"))).isInstance(file)) {
                            object = file.getClass().getMethod("getIcon", Boolean.TYPE);
                            ((Method)object).setAccessible(true);
                            object = (Image)((Method)object).invoke((Object)file, Boolean.TRUE);
                            if (object != null) {
                                return new ImageIcon((Image)object);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if ("java.lang.reflect.InaccessibleObjectException".equals(exception.getClass().getName())) break block9;
                        LoggingFacade.INSTANCE.logSevere(null, exception);
                    }
                }
                return fileSystemView.getSystemIcon(file);
            }
            catch (NullPointerException nullPointerException) {
                return new FlatFileViewDirectoryIcon();
            }
        }

        protected void directoryChanged(File file) {
            if (file != null) {
                String string = file.getAbsolutePath();
                for (int i = 0; i < this.files.length; ++i) {
                    if (!this.files[i].equals(file) && !this.files[i].getAbsolutePath().equals(string)) continue;
                    this.buttons[i].setSelected(true);
                    return;
                }
            }
            this.buttonGroup.clearSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent object) {
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "directoryChanged": {
                    FlatShortcutsPanel flatShortcutsPanel = this;
                    flatShortcutsPanel.directoryChanged(flatShortcutsPanel.fc.getCurrentDirectory());
                }
            }
        }

        private static /* synthetic */ void lambda$new$0(JFileChooser jFileChooser, File file, ActionEvent actionEvent) {
            jFileChooser.setCurrentDirectory(file);
        }
    }

    private class FlatFileView
    extends BasicFileChooserUI.BasicFileView {
        private FlatFileView() {
            super(FlatFileChooserUI.this);
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                try {
                    icon = FlatFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
                }
                catch (NullPointerException nullPointerException) {}
                if (icon != null) {
                    if (icon instanceof ImageIcon) {
                        icon = new ScaledImageIcon((ImageIcon)icon);
                    }
                    this.cacheIcon(file, icon);
                    return icon;
                }
            }
            if ((icon = super.getIcon(file)) instanceof ImageIcon) {
                icon = new ScaledImageIcon((ImageIcon)icon);
                this.cacheIcon(file, icon);
            }
            return icon;
        }
    }
}

