/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatNativeLibrary;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JDialog;
import javax.swing.JFrame;

class FlatNativeLinuxLibrary {
    private static int API_VERSION_LINUX = 3001;
    static final int MOVE = 8;
    private static Boolean isXWindowSystem;

    FlatNativeLinuxLibrary() {
    }

    static boolean isLoaded() {
        return SystemInfo.isLinux && FlatNativeLibrary.isLoaded(API_VERSION_LINUX);
    }

    private static boolean isXWindowSystem() {
        if (isXWindowSystem == null) {
            isXWindowSystem = Toolkit.getDefaultToolkit().getClass().getName().endsWith(".XToolkit");
        }
        return isXWindowSystem;
    }

    static boolean isWMUtilsSupported(Window window) {
        return FlatNativeLinuxLibrary.hasCustomDecoration(window) && FlatNativeLinuxLibrary.isXWindowSystem() && FlatNativeLinuxLibrary.isLoaded();
    }

    static boolean moveOrResizeWindow(Window window, MouseEvent serializable, int n) {
        serializable = FlatNativeLinuxLibrary.scale(window, serializable.getLocationOnScreen());
        return FlatNativeLinuxLibrary.xMoveOrResizeWindow(window, ((Point)serializable).x, ((Point)serializable).y, n);
    }

    static boolean showWindowMenu(Window window, MouseEvent serializable) {
        serializable = FlatNativeLinuxLibrary.scale(window, serializable.getLocationOnScreen());
        return FlatNativeLinuxLibrary.xShowWindowMenu(window, ((Point)serializable).x, ((Point)serializable).y);
    }

    private static Point scale(Window serializable, Point point) {
        serializable = ((Component)serializable).getGraphicsConfiguration().getDefaultTransform();
        int n = (int)Math.round((double)point.x * ((AffineTransform)serializable).getScaleX());
        int n2 = (int)Math.round((double)point.y * ((AffineTransform)serializable).getScaleY());
        return new Point(n, n2);
    }

    private static native boolean xMoveOrResizeWindow(Window var0, int var1, int var2, int var3);

    private static native boolean xShowWindowMenu(Window var0, int var1, int var2);

    private static boolean hasCustomDecoration(Window window) {
        return window instanceof JFrame && JFrame.isDefaultLookAndFeelDecorated() && ((JFrame)window).isUndecorated() || window instanceof JDialog && JDialog.isDefaultLookAndFeelDecorated() && ((JDialog)window).isUndecorated();
    }
}

