/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FlatTableHeaderBorder
extends FlatEmptyBorder {
    protected Color separatorColor = UIManager.getColor("TableHeader.separatorColor");
    protected Color bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
    protected boolean showTrailingVerticalLine = UIManager.getBoolean("TableHeader.showTrailingVerticalLine");

    public FlatTableHeaderBorder() {
        super(UIManager.getInsets("TableHeader.cellMargins"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Object object = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        if (object != null && ((JTableHeader)object).getUI() instanceof FlatTableHeaderUI) {
            object = (FlatTableHeaderUI)((JTableHeader)object).getUI();
            if (((FlatTableHeaderUI)object).cellMargins != null) {
                object = ((FlatTableHeaderUI)object).cellMargins;
                return FlatTableHeaderBorder.scaleInsets(component, insets, ((Insets)object).top, ((Insets)object).left, ((Insets)object).bottom, ((Insets)object).right);
            }
        }
        return super.getBorderInsets(component, insets);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        boolean bl = ((Component)(object != null ? object : component)).getComponentOrientation().isLeftToRight();
        boolean bl2 = !bl;
        boolean bl3 = bl;
        Color color = this.separatorColor;
        Color color2 = this.bottomSeparatorColor;
        if (object != null) {
            int n5 = SwingUtilities.convertPoint((Component)component, (int)n, (int)n2, (Component)object).x;
            if (this.isDraggedColumn((JTableHeader)object, n5)) {
                bl3 = true;
                bl2 = true;
            } else {
                if (n5 <= 0 && !bl && this.hideTrailingVerticalLine((JTableHeader)object)) {
                    bl2 = false;
                }
                if (n5 + n3 >= ((JComponent)object).getWidth() && bl && this.hideTrailingVerticalLine((JTableHeader)object)) {
                    bl3 = false;
                }
            }
            if (((JTableHeader)object).getUI() instanceof FlatTableHeaderUI) {
                object = (FlatTableHeaderUI)((JTableHeader)object).getUI();
                if (((FlatTableHeaderUI)object).separatorColor != null) {
                    color = ((FlatTableHeaderUI)object).separatorColor;
                }
                if (((FlatTableHeaderUI)object).bottomSeparatorColor != null) {
                    color2 = ((FlatTableHeaderUI)object).bottomSeparatorColor;
                }
            }
        }
        float f = UIScale.scale(1.0f);
        object = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)object);
            ((Graphics)object).setColor(color);
            if (bl2) {
                ((Graphics2D)object).fill(new Rectangle2D.Float(n, n2, f, (float)n4 - f));
            }
            if (bl3) {
                ((Graphics2D)object).fill(new Rectangle2D.Float((float)(n + n3) - f, n2, f, (float)n4 - f));
            }
            ((Graphics)object).setColor(color2);
            ((Graphics2D)object).fill(new Rectangle2D.Float(n, (float)(n2 + n4) - f, n3, f));
            return;
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    protected boolean isDraggedColumn(JTableHeader jTableHeader, int n) {
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn == null) {
            return false;
        }
        int n2 = jTableHeader.getDraggedDistance();
        if (n2 == 0) {
            return false;
        }
        int n3 = jTableHeader.getColumnModel().getColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (jTableHeader.getHeaderRect((int)i).x + n2 != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hideTrailingVerticalLine(JTableHeader container) {
        Object object;
        if (((JTableHeader)container).getUI() instanceof FlatTableHeaderUI) {
            object = (FlatTableHeaderUI)((JTableHeader)container).getUI();
            if (((FlatTableHeaderUI)object).showTrailingVerticalLine != null) {
                return ((FlatTableHeaderUI)object).showTrailingVerticalLine == false;
            }
        }
        if (this.showTrailingVerticalLine) {
            return false;
        }
        object = container.getParent();
        if (!((container = object != null ? ((Component)object).getParent() : null) instanceof JScrollPane)) {
            return false;
        }
        JViewport jViewport = ((JScrollPane)(container = (JScrollPane)container)).getColumnHeader();
        if (object != jViewport) {
            return false;
        }
        if ((container = ((JScrollPane)container).getVerticalScrollBar()) == null || !container.isVisible()) {
            return true;
        }
        return ((JComponent)container).getY() == ((Component)object).getY();
    }
}

