/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final SourceCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    private final HttpHeadersFactory headersFactory;
    private final HttpHeadersFactory trailersFactory;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this(sourceCodec, upgradeCodecFactory, 0, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int n) {
        this(sourceCodec, upgradeCodecFactory, n, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int n, boolean bl) {
        this(sourceCodec, upgradeCodecFactory, n, DefaultHttpHeadersFactory.headersFactory().withValidation(bl), DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int n, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        super(n);
        this.sourceCodec = (SourceCodec)ObjectUtil.checkNotNull((Object)sourceCodec, (String)"sourceCodec");
        this.upgradeCodecFactory = (UpgradeCodecFactory)ObjectUtil.checkNotNull((Object)upgradeCodecFactory, (String)"upgradeCodecFactory");
        this.headersFactory = (HttpHeadersFactory)ObjectUtil.checkNotNull((Object)httpHeadersFactory, (String)"headersFactory");
        this.trailersFactory = (HttpHeadersFactory)ObjectUtil.checkNotNull((Object)httpHeadersFactory2, (String)"trailersFactory");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        void var4_7;
        if (!this.handlingUpgrade) {
            if (!(httpObject instanceof HttpRequest)) {
                ReferenceCountUtil.retain((Object)httpObject);
                channelHandlerContext.fireChannelRead((Object)httpObject);
                return;
            }
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (httpRequest.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && this.shouldHandleUpgradeRequest(httpRequest)) {
                this.handlingUpgrade = true;
            } else {
                ReferenceCountUtil.retain((Object)httpObject);
                channelHandlerContext.fireChannelRead((Object)httpObject);
                return;
            }
        }
        if (httpObject instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpObject;
            ReferenceCountUtil.retain((Object)httpObject);
            list.add(httpObject);
        } else {
            super.decode(channelHandlerContext, (Object)httpObject, list);
            if (list.isEmpty()) {
                return;
            }
            assert (list.size() == 1);
            this.handlingUpgrade = false;
            FullHttpRequest fullHttpRequest = (FullHttpRequest)list.get(0);
        }
        if (this.upgrade(channelHandlerContext, (FullHttpRequest)var4_7)) {
            list.clear();
        }
    }

    protected boolean shouldHandleUpgradeRequest(HttpRequest httpRequest) {
        return true;
    }

    private boolean upgrade(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        Object object;
        CharSequence charSequence;
        List<CharSequence> object22 = HttpServerUpgradeHandler.splitHeader(fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
        int n = object22.size();
        UpgradeCodec upgradeCodec = null;
        CharSequence charSequence2 = null;
        for (int i = 0; i < n; ++i) {
            charSequence = object22.get(i);
            object = this.upgradeCodecFactory.newUpgradeCodec(charSequence);
            if (object == null) continue;
            charSequence2 = charSequence;
            upgradeCodec = object;
            break;
        }
        if (upgradeCodec == null) {
            return false;
        }
        List<String> list = fullHttpRequest.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
        if (list == null || list.isEmpty()) {
            return false;
        }
        charSequence = new StringBuilder(list.size() * 10);
        for (CharSequence charSequence3 : list) {
            ((StringBuilder)charSequence).append(charSequence3).append(',');
        }
        CharSequence charSequence4 = charSequence;
        ((StringBuilder)charSequence4).setLength(((StringBuilder)charSequence4).length() - 1);
        object = upgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list2 = HttpServerUpgradeHandler.splitHeader(charSequence);
        if (!AsciiString.containsContentEqualsIgnoreCase(list2, (CharSequence)HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list2, object)) {
            return false;
        }
        Iterator<CharSequence> iterator = object.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence5 = iterator.next();
            if (fullHttpRequest.headers().contains(charSequence5)) continue;
            return false;
        }
        FullHttpResponse fullHttpResponse = this.createUpgradeResponse(charSequence2);
        if (!upgradeCodec.prepareUpgradeResponse(channelHandlerContext, fullHttpRequest, fullHttpResponse.headers())) {
            return false;
        }
        UpgradeEvent upgradeEvent = new UpgradeEvent(charSequence2, fullHttpRequest);
        try {
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)fullHttpResponse);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            upgradeCodec.upgradeTo(channelHandlerContext, fullHttpRequest);
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            channelHandlerContext.fireUserEventTriggered((Object)upgradeEvent.retain());
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            upgradeEvent.release();
        }
        return true;
    }

    private FullHttpResponse createUpgradeResponse(CharSequence charSequence) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, this.headersFactory, this.trailersFactory);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)charSequence);
        return defaultFullHttpResponse;
    }

    private static List<CharSequence> splitHeader(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static final class UpgradeEvent
    implements ReferenceCounted {
        private final CharSequence protocol;
        private final FullHttpRequest upgradeRequest;

        UpgradeEvent(CharSequence charSequence, FullHttpRequest fullHttpRequest) {
            this.protocol = charSequence;
            this.upgradeRequest = fullHttpRequest;
        }

        public final CharSequence protocol() {
            return this.protocol;
        }

        public final FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public final int refCnt() {
            return this.upgradeRequest.refCnt();
        }

        public final UpgradeEvent retain() {
            this.upgradeRequest.retain();
            return this;
        }

        public final UpgradeEvent retain(int n) {
            this.upgradeRequest.retain(n);
            return this;
        }

        public final UpgradeEvent touch() {
            this.upgradeRequest.touch();
            return this;
        }

        public final UpgradeEvent touch(Object object) {
            this.upgradeRequest.touch(object);
            return this;
        }

        public final boolean release() {
            return this.upgradeRequest.release();
        }

        public final boolean release(int n) {
            return this.upgradeRequest.release(n);
        }

        public final String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }

    public static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec(CharSequence var1);
    }

    public static interface UpgradeCodec {
        public Collection<CharSequence> requiredUpgradeHeaders();

        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, HttpHeaders var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

