/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.util.internal.ObjectUtil;

public class DefaultCookie
implements Cookie {
    private final String name;
    private String value;
    private boolean wrap;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private CookieHeaderNames.SameSite sameSite;
    private boolean partitioned;

    public DefaultCookie(String string, String string2) {
        this.name = ObjectUtil.checkNonEmptyAfterTrim((String)string, (String)"name");
        this.setValue(string2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public void setValue(String string) {
        this.value = (String)ObjectUtil.checkNotNull((Object)string, (String)"value");
    }

    @Override
    public boolean wrap() {
        return this.wrap;
    }

    @Override
    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public void setDomain(String string) {
        this.domain = CookieUtil.validateAttributeValue("domain", string);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public void setPath(String string) {
        this.path = CookieUtil.validateAttributeValue("path", string);
    }

    @Override
    public long maxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(long l) {
        this.maxAge = l;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    public CookieHeaderNames.SameSite sameSite() {
        return this.sameSite;
    }

    public void setSameSite(CookieHeaderNames.SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean bl) {
        this.partitioned = bl;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        if (!this.name().equals(object.name())) {
            return false;
        }
        if (this.path() == null) {
            if (object.path() != null) {
                return false;
            }
        } else {
            if (object.path() == null) {
                return false;
            }
            if (!this.path().equals(object.path())) {
                return false;
            }
        }
        if (this.domain() == null) {
            return object.domain() == null;
        }
        return this.domain().equalsIgnoreCase(object.domain());
    }

    @Override
    public int compareTo(Cookie cookie) {
        int n = this.name().compareTo(cookie.name());
        if (n != 0) {
            return n;
        }
        if (this.path() == null) {
            if (cookie.path() != null) {
                return -1;
            }
        } else {
            if (cookie.path() == null) {
                return 1;
            }
            n = this.path().compareTo(cookie.path());
            if (n != 0) {
                return n;
            }
        }
        if (this.domain() == null) {
            if (cookie.domain() != null) {
                return -1;
            }
        } else {
            if (cookie.domain() == null) {
                return 1;
            }
            n = this.domain().compareToIgnoreCase(cookie.domain());
            return n;
        }
        return 0;
    }

    @Deprecated
    protected String validateValue(String string, String string2) {
        return CookieUtil.validateAttributeValue(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = CookieUtil.stringBuilder().append(this.name()).append('=').append(this.value());
        if (this.domain() != null) {
            stringBuilder.append(", domain=").append(this.domain());
        }
        if (this.path() != null) {
            stringBuilder.append(", path=").append(this.path());
        }
        if (this.maxAge() >= 0L) {
            stringBuilder.append(", maxAge=").append(this.maxAge()).append('s');
        }
        if (this.isSecure()) {
            stringBuilder.append(", secure");
        }
        if (this.isHttpOnly()) {
            stringBuilder.append(", HTTPOnly");
        }
        if (this.sameSite() != null) {
            stringBuilder.append(", SameSite=").append((Object)this.sameSite());
        }
        if (this.isPartitioned()) {
            stringBuilder.append(", Partitioned");
        }
        return stringBuilder.toString();
    }
}

