/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.handler.codec.spdy.SpdyUnknownFrame;
import io.netty.util.internal.StringUtil;

public final class DefaultSpdyUnknownFrame
extends DefaultByteBufHolder
implements SpdyUnknownFrame {
    private final int frameType;
    private final byte flags;

    public DefaultSpdyUnknownFrame(int n, byte by, ByteBuf byteBuf) {
        super(byteBuf);
        this.frameType = n;
        this.flags = by;
    }

    @Override
    public final int frameType() {
        return this.frameType;
    }

    @Override
    public final byte flags() {
        return this.flags;
    }

    @Override
    public final DefaultSpdyUnknownFrame copy() {
        DefaultSpdyUnknownFrame defaultSpdyUnknownFrame = this;
        return defaultSpdyUnknownFrame.replace(defaultSpdyUnknownFrame.content().copy());
    }

    @Override
    public final DefaultSpdyUnknownFrame duplicate() {
        DefaultSpdyUnknownFrame defaultSpdyUnknownFrame = this;
        return defaultSpdyUnknownFrame.replace(defaultSpdyUnknownFrame.content().duplicate());
    }

    @Override
    public final DefaultSpdyUnknownFrame retainedDuplicate() {
        DefaultSpdyUnknownFrame defaultSpdyUnknownFrame = this;
        return defaultSpdyUnknownFrame.replace(defaultSpdyUnknownFrame.content().retainedDuplicate());
    }

    @Override
    public final DefaultSpdyUnknownFrame replace(ByteBuf byteBuf) {
        return new DefaultSpdyUnknownFrame(this.frameType, this.flags, byteBuf);
    }

    @Override
    public final DefaultSpdyUnknownFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public final DefaultSpdyUnknownFrame retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public final DefaultSpdyUnknownFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public final DefaultSpdyUnknownFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DefaultSpdyUnknownFrame)) {
            return false;
        }
        object = (DefaultSpdyUnknownFrame)object;
        return this.frameType == ((DefaultSpdyUnknownFrame)object).frameType && this.flags == ((DefaultSpdyUnknownFrame)object).flags && super.equals(object);
    }

    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.frameType;
        n = n * 31 + this.flags;
        return n;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(frameType=" + this.frameType + ", flags=" + this.flags + ", content=" + this.contentToString() + ')';
    }
}

