/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSLContext;
import java.util.concurrent.locks.Lock;

public final class OpenSslSessionStats {
    private final ReferenceCountedOpenSslContext context;

    OpenSslSessionStats(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        this.context = referenceCountedOpenSslContext;
    }

    public final long number() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionNumber((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long connect() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionConnect((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long connectGood() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionConnectGood((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long connectRenegotiate() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionConnectRenegotiate((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long accept() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionAccept((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long acceptGood() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionAcceptGood((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long acceptRenegotiate() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionAcceptRenegotiate((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long hits() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionHits((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long cbHits() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionCbHits((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long misses() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionMisses((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long timeouts() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionTimeouts((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long cacheFull() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionCacheFull((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long ticketKeyFail() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionTicketKeyFail((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long ticketKeyNew() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionTicketKeyNew((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long ticketKeyRenew() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionTicketKeyRenew((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long ticketKeyResume() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.sessionTicketKeyResume((long)this.context.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }
}

