/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.ssl.util.BouncyCastleSelfSignedCertGenerator;
import io.netty.handler.ssl.util.OpenJdkSelfSignedCertGenerator;
import io.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class SelfSignedCertificate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelfSignedCertificate.class);
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotBefore", (long)(System.currentTimeMillis() - 31536000000L)));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotAfter", (long)253402300799000L));
    private static final int DEFAULT_KEY_LENGTH_BITS = SystemPropertyUtil.getInt((String)"io.netty.handler.ssl.util.selfSignedKeyStrength", (int)2048);
    private final File certificate;
    private final File privateKey;
    private final X509Certificate cert;
    private final PrivateKey key;

    public SelfSignedCertificate() {
        this(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(Date date, Date date2) {
        this("localhost", date, date2, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(Date date, Date date2, String string, int n) {
        this("localhost", date, date2, string, n);
    }

    public SelfSignedCertificate(String string) {
        this(string, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    public SelfSignedCertificate(String string, String string2, int n) {
        this(string, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, string2, n);
    }

    public SelfSignedCertificate(String string, Date date, Date date2) {
        this(string, ThreadLocalInsecureRandom.current(), DEFAULT_KEY_LENGTH_BITS, date, date2, "RSA");
    }

    public SelfSignedCertificate(String string, Date date, Date date2, String string2, int n) {
        this(string, ThreadLocalInsecureRandom.current(), n, date, date2, string2);
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n) {
        this(string, secureRandom, n, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA");
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, String string2, int n) {
        this(string, secureRandom, n, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, string2);
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n, Date date, Date date2) {
        this(string, secureRandom, n, date, date2, "RSA");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n, Date date, Date date2, String string2) {
        KeyPair keyPair;
        String[] stringArray;
        if (!"EC".equalsIgnoreCase(string2) && !"RSA".equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("Algorithm not valid: " + string2);
        }
        try {
            stringArray = KeyPairGenerator.getInstance(string2);
            stringArray.initialize(n, secureRandom);
            keyPair = stringArray.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        try {
            stringArray = BouncyCastleSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2, string2);
        }
        catch (Throwable throwable) {
            if (!SelfSignedCertificate.isBouncyCastleAvailable()) {
                logger.debug("Failed to generate a self-signed X.509 certificate because BouncyCastle PKIX is not available in classpath");
            } else {
                logger.debug("Failed to generate a self-signed X.509 certificate using Bouncy Castle:", throwable);
            }
            try {
                stringArray = OpenJdkSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2, string2);
            }
            catch (Throwable throwable2) {
                logger.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", throwable2);
                CertificateException certificateException = new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.", throwable2);
                ThrowableUtil.addSuppressed((Throwable)certificateException, (Throwable)throwable);
                throw certificateException;
            }
        }
        this.certificate = new File(stringArray[0]);
        this.privateKey = new File(stringArray[1]);
        this.key = keyPair.getPrivate();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(fileInputStream);
        }
        catch (Exception exception) {
            try {
                throw new CertificateEncodingException(exception);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    if (!logger.isWarnEnabled()) throw throwable;
                    logger.warn("Failed to close a file: " + this.certificate, (Throwable)iOException);
                }
                throw throwable;
            }
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            if (!logger.isWarnEnabled()) return;
            logger.warn("Failed to close a file: " + this.certificate, (Throwable)iOException);
            return;
        }
    }

    public final File certificate() {
        return this.certificate;
    }

    public final File privateKey() {
        return this.privateKey;
    }

    public final X509Certificate cert() {
        return this.cert;
    }

    public final PrivateKey key() {
        return this.key;
    }

    public final void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    static String[] newSelfSignedCertificate(String object, PrivateKey privateKey, X509Certificate object2) {
        String string;
        Object object3;
        privateKey = Unpooled.wrappedBuffer((byte[])privateKey.getEncoded());
        try {
            object3 = Base64.encode((ByteBuf)privateKey, (boolean)true);
            try {
                string = "-----BEGIN PRIVATE KEY-----\n" + object3.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                object3.release();
            }
        }
        finally {
            privateKey.release();
        }
        object = ((String)object).replaceAll("[^\\w.-]", "x");
        File file = PlatformDependent.createTempFile((String)("keyutil_" + (String)object + '_'), (String)".key", null);
        file.deleteOnExit();
        object3 = new FileOutputStream(file);
        try {
            ((OutputStream)object3).write(string.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)object3).close();
            object3 = null;
        }
        catch (Throwable throwable) {
            SelfSignedCertificate.safeClose(file, (OutputStream)object3);
            SelfSignedCertificate.safeDelete(file);
            throw throwable;
        }
        privateKey = Unpooled.wrappedBuffer((byte[])((Certificate)object2).getEncoded());
        try {
            object3 = Base64.encode((ByteBuf)privateKey, (boolean)true);
            try {
                object2 = "-----BEGIN CERTIFICATE-----\n" + object3.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                object3.release();
            }
        }
        finally {
            privateKey.release();
        }
        object = PlatformDependent.createTempFile((String)("keyutil_" + (String)object + '_'), (String)".crt", null);
        ((File)object).deleteOnExit();
        object3 = new FileOutputStream((File)object);
        try {
            ((OutputStream)object3).write(((String)object2).getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)object3).close();
            object3 = null;
        }
        catch (Throwable throwable) {
            SelfSignedCertificate.safeClose((File)object, (OutputStream)object3);
            SelfSignedCertificate.safeDelete((File)object);
            SelfSignedCertificate.safeDelete(file);
            throw throwable;
        }
        return new String[]{((File)object).getPath(), file.getPath()};
    }

    private static void safeDelete(File file) {
        if (!file.delete() && logger.isWarnEnabled()) {
            logger.warn("Failed to delete a file: " + file);
        }
    }

    private static void safeClose(File file, OutputStream outputStream) {
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to close a file: " + file, (Throwable)iOException);
            }
            return;
        }
    }

    private static boolean isBouncyCastleAvailable() {
        try {
            Class.forName("org.bouncycastle.cert.X509v3CertificateBuilder");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

