/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

public final class MathUtil {
    private MathUtil() {
    }

    public static int findNextPositivePowerOfTwo(int n) {
        assert (n > Integer.MIN_VALUE && n < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int n) {
        if (n <= 0) {
            return 1;
        }
        if (n >= 0x40000000) {
            return 0x40000000;
        }
        return MathUtil.findNextPositivePowerOfTwo(n);
    }

    public static boolean isOutOfBounds(int n, int n2, int n3) {
        return (n | n2 | n3 | n + n2 | n3 - (n + n2)) < 0;
    }

    public static int compare(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static int compare(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }
}

