/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.packet.RosterPacket;

public class RosterGroup
extends Manager {
    private final String name;
    private final Set<RosterEntry> entries;

    RosterGroup(String string, XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.name = string;
        this.entries = new LinkedHashSet<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                RosterPacket.Item object = RosterEntry.toRosterItem(rosterEntry);
                object.removeGroupName(this.name);
                object.addGroupName(string);
                rosterPacket.addRosterItem(object);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
            return;
        }
    }

    public int getEntryCount() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.size();
        }
    }

    public List<RosterEntry> getEntries() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return new ArrayList<RosterEntry>(this.entries);
        }
    }

    public RosterEntry getEntry(i i2) {
        if (i2 == null) {
            return null;
        }
        i2 = i2.n();
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry rosterEntry : this.entries) {
                if (!rosterEntry.getJid().a((CharSequence)i2)) continue;
                return rosterEntry;
            }
        }
        return null;
    }

    public boolean contains(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.contains((Object)rosterEntry);
        }
    }

    public boolean contains(i i2) {
        return this.getEntry(i2) != null;
    }

    public void addEntry(RosterEntry object) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (!this.entries.contains(object)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                object = RosterEntry.toRosterItem(object);
                ((RosterPacket.Item)object).addGroupName(this.getName());
                rosterPacket.addRosterItem((RosterPacket.Item)object);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
            return;
        }
    }

    public void removeEntry(RosterEntry object) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains(object)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.set);
                object = RosterEntry.toRosterItem(object);
                ((RosterPacket.Item)object).removeGroupName(this.getName());
                rosterPacket.addRosterItem((RosterPacket.Item)object);
                this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
            }
            return;
        }
    }

    void addEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            this.entries.remove((Object)rosterEntry);
            this.entries.add(rosterEntry);
            return;
        }
    }

    void removeEntryLocal(RosterEntry rosterEntry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains((Object)rosterEntry)) {
                this.entries.remove((Object)rosterEntry);
            }
            return;
        }
    }
}

