/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String KLEENE_STAR = "*";
    HashMap<ElementSelector, Supplier<Action>> rules = new HashMap();
    List<String> transparentPathParts = new ArrayList<String>(2);
    Map<String, String> pathPartsMapForRenaming = new HashMap<String, String>(2);

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    @Override
    public void addTransparentPathPart(String string) {
        if (string == null) {
            throw new IllegalArgumentException("pathPart cannot be null");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new IllegalArgumentException("pathPart cannot be empty or to consist of only spaces");
        }
        if (string.contains("/")) {
            throw new IllegalArgumentException("pathPart cannot contain '/', i.e. the forward slash character");
        }
        this.transparentPathParts.add(string);
    }

    @Override
    public void addPathPathMapping(String string, String string2) {
        this.pathPartsMapForRenaming.put(string, string2);
    }

    @Override
    public void addRule(ElementSelector elementSelector, Supplier<Action> supplier) {
        Supplier<Action> supplier2 = this.rules.get(elementSelector);
        if (supplier2 == null) {
            this.rules.put(elementSelector, supplier);
            return;
        }
        throw new IllegalStateException(elementSelector.toString() + " already has an associated action supplier");
    }

    @Override
    public void addRule(ElementSelector elementSelector, String string) {
        try {
            Action cfr_ignored_0 = (Action)OptionHelper.instantiateByClassName(string, Action.class, this.context);
            return;
        }
        catch (Exception exception) {
            this.addError("Could not instantiate class [" + string + "]", exception);
            return;
        }
    }

    @Override
    public Supplier<Action> matchActions(ElementPath elementPath) {
        Supplier<Action> supplier = this.internalMatchAction(elementPath);
        if (supplier != null) {
            return supplier;
        }
        return this.matchActionsWithoutTransparentPartsAndRenamedParts(elementPath);
    }

    private Supplier<Action> matchActionsWithoutTransparentPartsAndRenamedParts(ElementPath elementPath) {
        elementPath = this.removeTransparentPathParts(elementPath);
        elementPath = this.renamePathParts(elementPath);
        return this.internalMatchAction(elementPath);
    }

    private Supplier<Action> internalMatchAction(ElementPath elementPath) {
        Supplier<Action> supplier = this.fullPathMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.suffixMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.prefixMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        supplier = this.middleMatch(elementPath);
        if (supplier != null) {
            return supplier;
        }
        return null;
    }

    ElementPath removeTransparentPathParts(ElementPath object) {
        ArrayList<String> arrayList = new ArrayList<String>(((ElementPath)object).partList.size());
        for (String string : ((ElementPath)object).partList) {
            boolean bl = this.transparentPathParts.stream().noneMatch(string2 -> string2.equalsIgnoreCase(string));
            if (!bl) continue;
            arrayList.add(string);
        }
        return new ElementPath(arrayList);
    }

    ElementPath renamePathParts(ElementPath object) {
        ArrayList<String> arrayList = new ArrayList<String>(((ElementPath)object).partList.size());
        object = ((ElementPath)object).partList.iterator();
        while (object.hasNext()) {
            String string;
            String string2 = string = (String)object.next();
            string = this.pathPartsMapForRenaming.getOrDefault(string2, string2);
            arrayList.add(string);
        }
        return new ElementPath(arrayList);
    }

    Supplier<Action> fullPathMatch(ElementPath elementPath) {
        for (ElementSelector elementSelector : this.rules.keySet()) {
            if (!elementSelector.fullPathMatch(elementPath)) continue;
            return this.rules.get(elementSelector);
        }
        return null;
    }

    Supplier<Action> suffixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            if (!this.isSuffixPattern(elementSelector2) || (n2 = elementSelector2.getTailMatchLength(elementPath)) <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isSuffixPattern(ElementSelector elementSelector) {
        return elementSelector.size() > 1 && elementSelector.get(0).equals(KLEENE_STAR);
    }

    Supplier<Action> prefixMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            int n2;
            String string = elementSelector2.peekLast();
            if (!this.isKleeneStar(string) || (n2 = elementSelector2.getPrefixMatchLength(elementPath)) != elementSelector2.size() - 1 || n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    private boolean isKleeneStar(String string) {
        return KLEENE_STAR.equals(string);
    }

    Supplier<Action> middleMatch(ElementPath elementPath) {
        int n = 0;
        ElementSelector elementSelector = null;
        for (ElementSelector elementSelector2 : this.rules.keySet()) {
            List<String> list = elementSelector2.peekLast();
            String string = null;
            if (elementSelector2.size() > 1) {
                string = elementSelector2.get(0);
            }
            if (!this.isKleeneStar((String)((Object)list)) || !this.isKleeneStar(string)) continue;
            list = elementSelector2.getCopyOfPartList();
            if (list.size() > 2) {
                list.remove(0);
                List<String> list2 = list;
                list2.remove(list2.size() - 1);
            }
            int n2 = 0;
            if (((ElementSelector)((Object)(list = new ElementSelector(list)))).isContainedIn(elementPath)) {
                n2 = ((ElementPath)((Object)list)).size();
            }
            if (n2 <= n) continue;
            n = n2;
            elementSelector = elementSelector2;
        }
        if (elementSelector != null) {
            return this.rules.get(elementSelector);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleRuleStore ( rules = ").append(this.rules).append("   )");
        return stringBuilder.toString();
    }
}

