/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.CachingDateFormatter;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class ViewStatusMessagesServletBase
extends HttpServlet {
    private static final long serialVersionUID = -3551928133801157219L;
    private static CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    static String SUBMIT = "submit";
    static String CLEAR = "Clear";
    int count;

    protected abstract StatusManager getStatusManager(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract String getPageTitle(HttpServletRequest var1, HttpServletResponse var2);

    protected void service(HttpServletRequest object, HttpServletResponse httpServletResponse) {
        this.count = 0;
        StatusManager statusManager = this.getStatusManager((HttpServletRequest)object, httpServletResponse);
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.append("<html>\r\n");
        printWriter.append("<head>\r\n");
        this.printCSS(object.getContextPath(), printWriter);
        printWriter.append("</head>\r\n");
        printWriter.append("<body>\r\n");
        printWriter.append(this.getPageTitle((HttpServletRequest)object, httpServletResponse));
        printWriter.append("<form method=\"POST\">\r\n");
        printWriter.append("<input type=\"submit\" name=\"" + SUBMIT + "\" value=\"" + CLEAR + "\">");
        printWriter.append("</form>\r\n");
        if (CLEAR.equalsIgnoreCase(object.getParameter(SUBMIT))) {
            statusManager.clear();
            statusManager.add(new InfoStatus("Cleared all status messages", (Object)this));
        }
        printWriter.append("<table>");
        object = new StringBuilder();
        if (statusManager != null) {
            this.printList((StringBuilder)object, statusManager);
        } else {
            printWriter.append("Could not find status manager");
        }
        printWriter.append((CharSequence)object);
        printWriter.append("</table>");
        printWriter.append("</body>\r\n");
        printWriter.append("</html>\r\n");
        printWriter.flush();
        printWriter.close();
    }

    public void printCSS(String string, PrintWriter printWriter) {
        printWriter.append("  <STYLE TYPE=\"text/css\">\r\n");
        printWriter.append("    .warn  { font-weight: bold; color: #FF6600;} \r\n");
        printWriter.append("    .error { font-weight: bold; color: #CC0000;} \r\n");
        printWriter.append("    table { margin-left: 2em; margin-right: 2em; border-left: 2px solid #AAA; }\r\n");
        printWriter.append("    tr.even { background: #FFFFFF; }\r\n");
        printWriter.append("    tr.odd  { background: #EAEAEA; }\r\n");
        printWriter.append("    td { padding-right: 1ex; padding-left: 1ex; border-right: 2px solid #AAA; }\r\n");
        printWriter.append("    td.date { text-align: right; font-family: courier, monospace; font-size: smaller; }");
        printWriter.append(CoreConstants.LINE_SEPARATOR);
        printWriter.append("  td.level { text-align: right; }");
        printWriter.append(CoreConstants.LINE_SEPARATOR);
        printWriter.append("    tr.header { background: #596ED5; color: #FFF; font-weight: bold; font-size: larger; }");
        printWriter.append(CoreConstants.LINE_SEPARATOR);
        printWriter.append("  td.exception { background: #A2AEE8; white-space: pre; font-family: courier, monospace;}");
        printWriter.append(CoreConstants.LINE_SEPARATOR);
        printWriter.append("  </STYLE>\r\n");
    }

    public void printList(StringBuilder stringBuilder, StatusManager iterator) {
        stringBuilder.append("<table>\r\n");
        this.printHeader(stringBuilder);
        iterator = iterator.getCopyOfStatusList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status status = iterator.next();
            ++this.count;
            this.printStatus(stringBuilder, status);
        }
        stringBuilder.append("</table>\r\n");
    }

    public void printHeader(StringBuilder stringBuilder) {
        stringBuilder.append("  <tr class=\"header\">\r\n");
        stringBuilder.append("    <th>Date </th>\r\n");
        stringBuilder.append("    <th>Level</th>\r\n");
        stringBuilder.append("    <th>Origin</th>\r\n");
        stringBuilder.append("    <th>Message</th>\r\n");
        stringBuilder.append("  </tr>\r\n");
    }

    String statusLevelAsString(Status status) {
        switch (status.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "<span class=\"warn\">WARN</span>";
            }
            case 2: {
                return "<span class=\"error\">ERROR</span>";
            }
        }
        return null;
    }

    String abbreviatedOrigin(Status object) {
        if ((object = object.getOrigin()) == null) {
            return null;
        }
        int n = ((String)(object = object.getClass().getName())).lastIndexOf(46);
        if (n != -1) {
            return ((String)object).substring(n + 1, ((String)object).length());
        }
        return object;
    }

    private void printStatus(StringBuilder stringBuilder, Status status) {
        String string = this.count % 2 == 0 ? "even" : "odd";
        stringBuilder.append("  <tr class=\"").append(string).append("\">\r\n");
        string = SDF.format(status.getTimestamp());
        stringBuilder.append("    <td class=\"date\">").append(string).append("</td>\r\n");
        stringBuilder.append("    <td class=\"level\">").append(this.statusLevelAsString(status)).append("</td>\r\n");
        stringBuilder.append("    <td>").append(this.abbreviatedOrigin(status)).append("</td>\r\n");
        stringBuilder.append("    <td>").append(status.getMessage()).append("</td>\r\n");
        stringBuilder.append("  </tr>\r\n");
        if (status.getThrowable() != null) {
            this.printThrowable(stringBuilder, status.getThrowable());
        }
    }

    private void printThrowable(StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append("  <tr>\r\n");
        stringBuilder.append("    <td colspan=\"4\" class=\"exception\"><pre>");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        stringBuilder.append(Transform.escapeTags(stringWriter.getBuffer()));
        stringBuilder.append("    </pre></td>\r\n");
        stringBuilder.append("  </tr>\r\n");
    }
}

