/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class CachingDateFormatter {
    final DateTimeFormatter dtf;
    final ZoneId zoneId;
    final AtomicReference<CacheTuple> atomicReference;

    public CachingDateFormatter(String string) {
        this(string, null);
    }

    public CachingDateFormatter(String string, ZoneId zoneId) {
        this(string, zoneId, null);
    }

    public CachingDateFormatter(String object, ZoneId serializable, Locale locale) {
        this.zoneId = serializable == null ? ZoneId.systemDefault() : serializable;
        serializable = locale != null ? locale : Locale.getDefault();
        this.dtf = DateTimeFormatter.ofPattern((String)object).withZone(this.zoneId).withLocale((Locale)serializable);
        object = new CacheTuple(-1L, null);
        this.atomicReference = new AtomicReference<Object>(object);
    }

    public final String format(long l) {
        Object object = this.atomicReference.get();
        CacheTuple cacheTuple = object;
        if (l != ((CacheTuple)object).lastTimestamp) {
            object = Instant.ofEpochMilli(l);
            object = this.dtf.format((TemporalAccessor)object);
            object = new CacheTuple(l, (String)object);
            this.atomicReference.compareAndSet(cacheTuple, (CacheTuple)object);
        }
        return ((CacheTuple)object).cachedStr;
    }

    static class CacheTuple {
        final long lastTimestamp;
        final String cachedStr;

        public CacheTuple(long l, String string) {
            this.lastTimestamp = l;
            this.cachedStr = string;
        }
    }
}

