/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class JavaClassDataFinder
implements ClassDataFinder {
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    public JavaClassDataFinder(KotlinClassFinder kotlinClassFinder, DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        Intrinsics.checkNotNullParameter((Object)deserializedDescriptorResolver, (String)"");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @Override
    public final ClassData findClassData(ClassId object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, (ClassId)object, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.deserializedDescriptorResolver.getComponents().getConfiguration()));
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual((Object)kotlinJvmBinaryClass.getClassId(), (Object)object);
        if (_Assertions.ENABLED && !bl) {
            object = "Class with incorrect id found: expected " + object + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw new AssertionError(object);
        }
        return this.deserializedDescriptorResolver.readClassData$descriptors_jvm(kotlinJvmBinaryClass2);
    }
}

