/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;

public class JvmDescriptorTypeWriter<T> {
    private final JvmTypeFactory<T> jvmTypeFactory;
    private int jvmCurrentTypeArrayLevel;
    private T jvmCurrentType;

    public void writeArrayType() {
        if (this.jvmCurrentType == null) {
            ++this.jvmCurrentTypeArrayLevel;
        }
    }

    public void writeArrayEnd() {
    }

    public void writeClass(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        this.writeJvmTypeAsIs(t);
    }

    protected final void writeJvmTypeAsIs(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (this.jvmCurrentType == null) {
            this.jvmCurrentType = this.jvmCurrentTypeArrayLevel > 0 ? this.jvmTypeFactory.createFromString(StringsKt.repeat((CharSequence)"[", (int)this.jvmCurrentTypeArrayLevel) + this.jvmTypeFactory.toString(t)) : t;
        }
    }

    public void writeTypeVariable(Name name, T t) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        this.writeJvmTypeAsIs(t);
    }
}

