/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;

public final class DescriptorKindFilter {
    public static final Companion Companion;
    private final List<DescriptorKindExclude> excludes;
    private final int kindMask;
    private static int nextMaskValue;
    private static final int NON_SINGLETON_CLASSIFIERS_MASK;
    private static final int SINGLETON_CLASSIFIERS_MASK;
    private static final int TYPE_ALIASES_MASK;
    private static final int PACKAGES_MASK;
    private static final int FUNCTIONS_MASK;
    private static final int VARIABLES_MASK;
    private static final int ALL_KINDS_MASK;
    private static final int CLASSIFIERS_MASK;
    private static final int VALUES_MASK;
    private static final int CALLABLES_MASK;
    public static final DescriptorKindFilter ALL;
    public static final DescriptorKindFilter CALLABLES;
    public static final DescriptorKindFilter NON_SINGLETON_CLASSIFIERS;
    public static final DescriptorKindFilter SINGLETON_CLASSIFIERS;
    public static final DescriptorKindFilter TYPE_ALIASES;
    public static final DescriptorKindFilter CLASSIFIERS;
    public static final DescriptorKindFilter PACKAGES;
    public static final DescriptorKindFilter FUNCTIONS;
    public static final DescriptorKindFilter VARIABLES;
    public static final DescriptorKindFilter VALUES;
    private static final List<Companion.MaskToName> DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
    private static final List<Companion.MaskToName> DEBUG_MASK_BIT_NAMES;

    public DescriptorKindFilter(int n, List<? extends DescriptorKindExclude> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        this.excludes = object;
        object = this.excludes;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (DescriptorKindExclude)object2;
            n &= ~((DescriptorKindExclude)object2).getFullyExcludedDescriptorKinds();
        }
        this.kindMask = n;
    }

    public /* synthetic */ DescriptorKindFilter(int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(n, list);
    }

    public final List<DescriptorKindExclude> getExcludes() {
        return this.excludes;
    }

    public final int getKindMask() {
        return this.kindMask;
    }

    public final boolean acceptsKinds(int n) {
        return (this.kindMask & n) != 0;
    }

    public final DescriptorKindFilter restrictedToKindsOrNull(int n) {
        if ((n = this.kindMask & n) == 0) {
            return null;
        }
        return new DescriptorKindFilter(n, this.excludes);
    }

    public final String toString() {
        Object v0;
        Object object;
        Object object2;
        Iterator iterator2;
        block3: {
            iterator2 = DEBUG_PREDEFINED_FILTERS_MASK_NAMES;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                object = (Companion.MaskToName)object2;
                if (!(((Companion.MaskToName)object).getMask() == this.kindMask)) continue;
                v0 = object2;
                break block3;
            }
            v0 = null;
        }
        Companion.MaskToName maskToName = v0;
        iterator2 = maskToName != null ? maskToName.getName() : null;
        String string = iterator2;
        if (iterator2 == null) {
            iterator2 = DEBUG_MASK_BIT_NAMES;
            object2 = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                object = t;
                object = t;
                object = (Companion.MaskToName)t;
                String string2 = this.acceptsKinds(((Companion.MaskToName)object).getMask()) ? ((Companion.MaskToName)object).getName() : null;
                if (string2 == null) continue;
                object = string2;
                object2.add((Object)object);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)object2), (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null);
        }
        iterator2 = string;
        return "DescriptorKindFilter(" + (String)((Object)iterator2) + ", " + this.excludes + ')';
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        DescriptorKindFilter cfr_ignored_0 = (DescriptorKindFilter)object;
        if (!Intrinsics.areEqual(this.excludes, ((DescriptorKindFilter)object).excludes)) {
            return false;
        }
        return this.kindMask == ((DescriptorKindFilter)object).kindMask;
    }

    public final int hashCode() {
        int n = ((Object)this.excludes).hashCode();
        n = n * 31 + this.kindMask;
        return n;
    }

    static {
        Iterable iterable;
        Iterable iterable2;
        Object[] objectArray;
        Iterable iterable3;
        Object object;
        Object object22;
        Object[] object32;
        Companion = new Companion(null);
        nextMaskValue = 1;
        NON_SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        SINGLETON_CLASSIFIERS_MASK = DescriptorKindFilter.Companion.nextMask();
        TYPE_ALIASES_MASK = DescriptorKindFilter.Companion.nextMask();
        PACKAGES_MASK = DescriptorKindFilter.Companion.nextMask();
        FUNCTIONS_MASK = DescriptorKindFilter.Companion.nextMask();
        VARIABLES_MASK = DescriptorKindFilter.Companion.nextMask();
        ALL_KINDS_MASK = DescriptorKindFilter.Companion.nextMask() - 1;
        CLASSIFIERS_MASK = NON_SINGLETON_CLASSIFIERS_MASK | SINGLETON_CLASSIFIERS_MASK | TYPE_ALIASES_MASK;
        VALUES_MASK = SINGLETON_CLASSIFIERS_MASK | FUNCTIONS_MASK | VARIABLES_MASK;
        CALLABLES_MASK = FUNCTIONS_MASK | VARIABLES_MASK;
        ALL = new DescriptorKindFilter(ALL_KINDS_MASK, null, 2, null);
        CALLABLES = new DescriptorKindFilter(CALLABLES_MASK, null, 2, null);
        NON_SINGLETON_CLASSIFIERS = new DescriptorKindFilter(NON_SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        SINGLETON_CLASSIFIERS = new DescriptorKindFilter(SINGLETON_CLASSIFIERS_MASK, null, 2, null);
        TYPE_ALIASES = new DescriptorKindFilter(TYPE_ALIASES_MASK, null, 2, null);
        CLASSIFIERS = new DescriptorKindFilter(CLASSIFIERS_MASK, null, 2, null);
        PACKAGES = new DescriptorKindFilter(PACKAGES_MASK, null, 2, null);
        FUNCTIONS = new DescriptorKindFilter(FUNCTIONS_MASK, null, 2, null);
        VARIABLES = new DescriptorKindFilter(VARIABLES_MASK, null, 2, null);
        VALUES = new DescriptorKindFilter(VALUES_MASK, null, 2, null);
        Field[] fieldArray = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
        Object[] objectArray2 = object32 = (Object[])fieldArray;
        Object object3 = new ArrayList();
        for (Object object22 : objectArray2) {
            object = (Field)object22;
            if (!Modifier.isStatic(((Field)object).getModifiers())) continue;
            object3.add(object22);
        }
        Iterable iterable4 = iterable3 = (Iterable)((List)object3);
        object = new ArrayList();
        object3 = iterable4;
        Iterator iterator2 = object3.iterator();
        while (iterator2.hasNext()) {
            Companion.MaskToName maskToName;
            Object object4 = iterator2.next();
            object22 = object4;
            Field field = (Field)object4;
            object3 = field.get(null);
            if ((object4 = object3 instanceof DescriptorKindFilter ? (DescriptorKindFilter)object3 : null) != null) {
                int n = ((DescriptorKindFilter)object4).kindMask;
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                maskToName = new Companion.MaskToName(n, string);
            } else {
                maskToName = null;
            }
            if (maskToName == null) continue;
            Companion.MaskToName maskToName2 = maskToName;
            object.add(maskToName2);
        }
        DEBUG_PREDEFINED_FILTERS_MASK_NAMES = (List)object;
        Field[] fieldArray2 = DescriptorKindFilter.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"");
        Object[] objectArray3 = objectArray = (Object[])fieldArray2;
        object3 = new ArrayList();
        for (Object object22 : objectArray3) {
            object = (Field)object22;
            if (!Modifier.isStatic(((Field)object).getModifiers())) continue;
            object3.add(object22);
        }
        Iterable iterable5 = iterable2 = (Iterable)((List)object3);
        object = new ArrayList();
        for (Object t : iterable5) {
            Field field = (Field)t;
            if (!Intrinsics.areEqual(field.getType(), Integer.TYPE)) continue;
            object.add(t);
        }
        Iterable iterable6 = iterable = (Iterable)((List)object);
        object = new ArrayList();
        object3 = iterable6;
        Iterator iterator3 = object3.iterator();
        while (iterator3.hasNext()) {
            Companion.MaskToName maskToName;
            Object t = iterator3.next();
            object22 = t;
            Field field = (Field)t;
            Object object5 = field.get(null);
            Intrinsics.checkNotNull((Object)object5);
            int n = (Integer)object5;
            int n2 = n == (n & -n) ? 1 : 0;
            if (n2 != 0) {
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                maskToName = new Companion.MaskToName(n, string);
            } else {
                maskToName = null;
            }
            if (maskToName == null) continue;
            Companion.MaskToName maskToName3 = maskToName;
            object.add(maskToName3);
        }
        DEBUG_MASK_BIT_NAMES = (List)object;
    }

    public static final class Companion {
        private Companion() {
        }

        private final int nextMask() {
            int n = nextMaskValue;
            nextMaskValue = nextMaskValue << 1;
            return n;
        }

        public final int getNON_SINGLETON_CLASSIFIERS_MASK() {
            return NON_SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getSINGLETON_CLASSIFIERS_MASK() {
            return SINGLETON_CLASSIFIERS_MASK;
        }

        public final int getTYPE_ALIASES_MASK() {
            return TYPE_ALIASES_MASK;
        }

        public final int getPACKAGES_MASK() {
            return PACKAGES_MASK;
        }

        public final int getFUNCTIONS_MASK() {
            return FUNCTIONS_MASK;
        }

        public final int getVARIABLES_MASK() {
            return VARIABLES_MASK;
        }

        public final int getALL_KINDS_MASK() {
            return ALL_KINDS_MASK;
        }

        public final int getCLASSIFIERS_MASK() {
            return CLASSIFIERS_MASK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        private static final class MaskToName {
            private final int mask;
            private final String name;

            public MaskToName(int n, String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"");
                this.mask = n;
                this.name = string;
            }

            public final int getMask() {
                return this.mask;
            }

            public final String getName() {
                return this.name;
            }
        }
    }
}

