/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;

public final class TypeWithEnhancementKt {
    public static final KotlinType getEnhancement(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (kotlinType instanceof TypeWithEnhancement) {
            return ((TypeWithEnhancement)((Object)kotlinType)).getEnhancement();
        }
        return null;
    }

    public static final UnwrappedType inheritEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType, Function1<? super KotlinType, ? extends KotlinType> function1) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        KotlinType kotlinType2 = TypeWithEnhancementKt.getEnhancement(kotlinType);
        return TypeWithEnhancementKt.wrapEnhancement(unwrappedType, kotlinType2 != null ? (KotlinType)function1.invoke((Object)kotlinType2) : null);
    }

    public static final UnwrappedType inheritEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeWithEnhancementKt.wrapEnhancement(unwrappedType, TypeWithEnhancementKt.getEnhancement(kotlinType));
    }

    public static final UnwrappedType wrapEnhancement(UnwrappedType unwrappedType, KotlinType kotlinType) {
        while (true) {
            Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
            if (!(unwrappedType instanceof TypeWithEnhancement)) break;
            unwrappedType = ((TypeWithEnhancement)((Object)unwrappedType)).getOrigin();
        }
        if (kotlinType == null || Intrinsics.areEqual((Object)kotlinType, (Object)unwrappedType)) {
            return unwrappedType;
        }
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof SimpleType) {
            return new SimpleTypeWithEnhancement((SimpleType)unwrappedType, kotlinType);
        }
        if (unwrappedType2 instanceof FlexibleType) {
            return new FlexibleTypeWithEnhancement((FlexibleType)unwrappedType, kotlinType);
        }
        throw new NoWhenBranchMatchedException();
    }
}

