/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01Unfairish
implements RecursiveLock {
    protected final Sync sync;

    public RecursiveLockImpl01Unfairish(Sync sync) {
        this.sync = sync;
    }

    public RecursiveLockImpl01Unfairish() {
        this(new SingleThreadSync());
    }

    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getLockedStack();
        }
    }

    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    @Override
    public final boolean isOwner(Thread thread) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.isOwner(thread);
        }
    }

    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = this.sync.getOwner();
            return thread != null && Thread.currentThread() != thread;
        }
    }

    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getHoldCount();
        }
    }

    @Override
    public final void validateLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            if (!this.sync.isOwner(Thread.currentThread())) {
                if (null == this.sync.getOwner()) {
                    throw new RuntimeException(this.threadName(Thread.currentThread()) + ": Not locked: " + this.toString());
                }
                if (null != this.sync.getLockedStack()) {
                    this.sync.getLockedStack().printStackTrace();
                }
                throw new RuntimeException(Thread.currentThread() + ": Not owner: " + this.toString());
            }
            return;
        }
    }

    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.getLockedStack()) {
                        this.sync.getLockedStack().printStackTrace();
                    }
                    throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.toString() + " - " + this.threadName(Thread.currentThread()));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
            return;
        }
    }

    @Override
    public final boolean tryLock(long l) {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = Thread.currentThread();
            if (TRACE_LOCK) {
                System.err.println("+++ LOCK 0 " + this.toString() + ", timeout " + l + " ms, cur " + this.threadName(thread));
            }
            if (this.sync.isOwner(thread)) {
                this.sync.incrHoldCount(thread);
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l && 0 < this.sync.getQSz()) {
                long l2;
                if (0L >= l) {
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XY " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l + " ms");
                    }
                    return false;
                }
                this.sync.incrQSz();
                do {
                    l2 = System.currentTimeMillis();
                    this.sync.wait(l);
                } while (null != this.sync.getOwner() && 0L < (l -= System.currentTimeMillis() - l2));
                this.sync.decrQSz();
                if (0L >= l && this.sync.getOwner() != null) {
                    if (TRACE_LOCK) {
                        System.err.println("+++ LOCK XX " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l + " ms");
                    }
                    return false;
                }
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X1 " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l + " ms");
                }
            } else if (TRACE_LOCK) {
                System.err.println("+++ LOCK X0 " + this.toString() + ", cur " + this.threadName(thread));
            }
            this.sync.setOwner(thread);
            this.sync.incrHoldCount(thread);
            if (DEBUG) {
                this.sync.setLockedStack(new Throwable("Previously locked by " + this.toString()));
            }
            return true;
        }
    }

    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
            return;
        }
    }

    @Override
    public void unlock(Runnable runnable) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread = Thread.currentThread();
            this.sync.decrHoldCount(thread);
            if (this.sync.getHoldCount() > 0) {
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return;
            }
            this.sync.setOwner(null);
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (runnable != null) {
                runnable.run();
            }
            if (TRACE_LOCK) {
                System.err.println("--- LOCK X0 " + this.toString() + ", cur " + this.threadName(thread) + ", signal any");
            }
            this.sync.notify();
            return;
        }
    }

    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getQSz();
        }
    }

    public String toString() {
        RecursiveLockImpl01Unfairish recursiveLockImpl01Unfairish = this;
        return this.syncName() + "[count " + this.sync.getHoldCount() + ", qsz " + this.sync.getQSz() + ", owner " + recursiveLockImpl01Unfairish.threadName(recursiveLockImpl01Unfairish.sync.getOwner()) + "]";
    }

    final String syncName() {
        return "<" + Integer.toHexString(this.hashCode()) + ", " + Integer.toHexString(this.sync.hashCode()) + ">";
    }

    final String threadName(Thread thread) {
        if (thread != null) {
            return "<" + thread.getName() + ">";
        }
        return "<NULL>";
    }

    static interface Sync {
        public Thread getOwner();

        public boolean isOwner(Thread var1);

        public void setOwner(Thread var1);

        public Throwable getLockedStack();

        public void setLockedStack(Throwable var1);

        public int getHoldCount();

        public void incrHoldCount(Thread var1);

        public void decrHoldCount(Thread var1);

        public int getQSz();

        public void incrQSz();

        public void decrQSz();
    }

    static class SingleThreadSync
    extends AbstractOwnableSynchronizer
    implements Sync {
        private int holdCount = 0;
        private int qsz = 0;
        private Throwable lockedStack = null;

        SingleThreadSync() {
        }

        @Override
        public final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        @Override
        public boolean isOwner(Thread thread) {
            return this.getExclusiveOwnerThread() == thread;
        }

        @Override
        public final void setOwner(Thread thread) {
            this.setExclusiveOwnerThread(thread);
        }

        @Override
        public final Throwable getLockedStack() {
            return this.lockedStack;
        }

        @Override
        public final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }

        @Override
        public final int getHoldCount() {
            return this.holdCount;
        }

        @Override
        public void incrHoldCount(Thread thread) {
            ++this.holdCount;
        }

        @Override
        public void decrHoldCount(Thread thread) {
            --this.holdCount;
        }

        @Override
        public final int getQSz() {
            return this.qsz;
        }

        @Override
        public final void incrQSz() {
            ++this.qsz;
        }

        @Override
        public final void decrQSz() {
            --this.qsz;
        }
    }
}

