/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;

class CloseListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected CloseListener(InBandBytestreamManager inBandBytestreamManager) {
        super("close", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = inBandBytestreamManager;
    }

    public IQ handleIQRequest(IQ iQ) {
        iQ = (Close)iQ;
        InBandBytestreamSession inBandBytestreamSession = this.manager.getSessions().get(iQ.getSessionID());
        if (inBandBytestreamSession == null) {
            try {
                this.manager.replyItemNotFoundPacket(iQ);
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                return null;
            }
        }
        try {
            inBandBytestreamSession.closeByPeer((Close)iQ);
        }
        catch (InterruptedException | SmackException.NotConnectedException throwable) {
            return null;
        }
        this.manager.getSessions().remove(iQ.getSessionID());
        return null;
    }
}

