/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.e.c.c;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;

public class DiscoverInfo
extends IQ
implements DiscoverInfoView {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new ArrayList<Feature>();
    private final Set<Feature> featuresSet = new HashSet<Feature>();
    private final List<Identity> identities = new ArrayList<Identity>();
    private final Set<String> identitiesSet = new HashSet<String>();
    private String node;
    private boolean containsDuplicateFeatures;

    DiscoverInfo(DiscoverInfoBuilder iterator, boolean bl) {
        super((AbstractIqBuilder)iterator, ELEMENT, NAMESPACE);
        this.features.addAll(((DiscoverInfoBuilder)((Object)iterator)).getFeatures());
        this.identities.addAll(((DiscoverInfoBuilder)((Object)iterator)).getIdentities());
        this.node = ((DiscoverInfoBuilder)((Object)iterator)).getNode();
        for (Feature feature : this.features) {
            boolean bl2 = this.featuresSet.add(feature);
            if (bl2) continue;
            this.containsDuplicateFeatures = true;
        }
        for (Identity identity : this.identities) {
            this.identitiesSet.add(identity.getKey());
        }
        if (!bl) {
            return;
        }
        if (this.containsDuplicateFeatures) {
            throw new IllegalArgumentException("The disco#info request contains duplicate features.");
        }
    }

    @Deprecated
    public DiscoverInfo() {
        super(ELEMENT, NAMESPACE);
    }

    public DiscoverInfo(DiscoverInfo discoverInfo) {
        super((IQ)discoverInfo);
        this.node = discoverInfo.getNode();
        this.features.addAll(discoverInfo.features);
        this.featuresSet.addAll(discoverInfo.featuresSet);
        this.identities.addAll(discoverInfo.identities);
        this.identitiesSet.addAll(discoverInfo.identitiesSet);
    }

    @Deprecated
    public boolean addFeature(String string) {
        return this.addFeature(new Feature(string));
    }

    @Deprecated
    public void addFeatures(Collection<String> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.addFeature(string);
        }
    }

    @Deprecated
    public boolean addFeature(Feature feature) {
        this.features.add(feature);
        boolean bl = this.featuresSet.add(feature);
        if (!bl) {
            this.containsDuplicateFeatures = true;
        }
        return bl;
    }

    @Override
    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    @Deprecated
    public void addIdentity(Identity identity) {
        this.identities.add(identity);
        this.identitiesSet.add(identity.getKey());
    }

    @Deprecated
    public void addIdentities(Collection<Identity> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Identity identity = (Identity)object.next();
            this.addIdentity(identity);
        }
    }

    @Override
    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public boolean hasIdentity(String string, String string2) {
        string = c.a((String)string, (String)string2);
        return this.identitiesSet.contains(string);
    }

    public List<Identity> getIdentities(String string, String string2) {
        ArrayList<Identity> arrayList = new ArrayList<Identity>(this.identities.size());
        for (Identity identity : this.identities) {
            if (!identity.getCategory().equals(string) || !identity.getType().equals(string2)) continue;
            arrayList.add(identity);
        }
        return arrayList;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Deprecated
    public void setNode(String string) {
        this.node = (String)StringUtils.requireNullOrNotEmpty((CharSequence)string, (String)"The node can not be the empty string");
    }

    public boolean containsFeature(CharSequence charSequence) {
        return this.features.contains(new Feature(charSequence));
    }

    public static boolean nullSafeContainsFeature(DiscoverInfo discoverInfo, CharSequence charSequence) {
        if (discoverInfo == null) {
            return false;
        }
        return discoverInfo.containsFeature(charSequence);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.optAttribute("node", this.getNode());
        iQChildElementXmlStringBuilder.rightAngleBracket();
        for (Identity object : this.identities) {
            iQChildElementXmlStringBuilder.append(object.toXML());
        }
        for (Feature feature : this.features) {
            iQChildElementXmlStringBuilder.append(feature.toXML());
        }
        return iQChildElementXmlStringBuilder;
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> linkedList = new LinkedList<Identity>();
        for (Identity identity : this.identities) {
            for (Identity identity2 : linkedList) {
                if (!identity.equals(identity2)) continue;
                return true;
            }
            linkedList.add(identity);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        return this.containsDuplicateFeatures;
    }

    public DiscoverInfoBuilder asBuilder(String string) {
        return new DiscoverInfoBuilder(this, string);
    }

    @Deprecated
    public DiscoverInfo clone() {
        return new DiscoverInfo(this);
    }

    public static DiscoverInfoBuilder builder(XMPPConnection xMPPConnection) {
        return new DiscoverInfoBuilder(xMPPConnection);
    }

    public static DiscoverInfoBuilder builder(IqData iqData) {
        return new DiscoverInfoBuilder(iqData);
    }

    public static DiscoverInfoBuilder builder(String string) {
        return new DiscoverInfoBuilder(string);
    }

    public static final class Feature {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(CharSequence charSequence) {
            this(charSequence.toString());
        }

        public Feature(String string) {
            this.variable = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"variable cannot be null");
        }

        public final String getVar() {
            return this.variable;
        }

        public final XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("feature");
            xmlStringBuilder.attribute("var", this.variable);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public final boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, feature) -> builder.append((Object)this.variable, (Object)feature.variable));
        }

        public final int hashCode() {
            return this.variable.hashCode();
        }

        public final String toString() {
            return this.toXML().toString();
        }
    }

    public static final class Identity
    implements Comparable<Identity> {
        private final String category;
        private final String type;
        private final String key;
        private final String name;
        private final String lang;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Identity(String string, String string2) {
            this(string, string2, null, null);
        }

        public Identity(String string, String string2, String string3) {
            this(string, string3, string2, null);
        }

        public Identity(String string, String string2, String string3, String string4) {
            this.category = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string, (String)"category cannot be null");
            this.type = (String)StringUtils.requireNotNullNorEmpty((CharSequence)string2, (String)"type cannot be null");
            this.key = c.a((String)string, (String)string2);
            this.name = string3;
            this.lang = string4;
        }

        public final String getCategory() {
            return this.category;
        }

        public final String getName() {
            return this.name;
        }

        public final String getType() {
            return this.type;
        }

        public final String getLanguage() {
            return this.lang;
        }

        private String getKey() {
            return this.key;
        }

        public final boolean isOfCategoryAndType(String string, String string2) {
            return this.category.equals(string) && this.type.equals(string2);
        }

        public final XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("identity");
            xmlStringBuilder.xmllangAttribute(this.lang);
            xmlStringBuilder.attribute("category", this.category);
            xmlStringBuilder.optAttribute("name", this.name);
            xmlStringBuilder.optAttribute("type", this.type);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }

        public final boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, identity) -> builder.append((Object)this.key, (Object)identity.key).append((Object)this.lang, (Object)identity.lang).append((Object)this.name, (Object)identity.name));
        }

        public final int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.key).append((Object)this.lang).append((Object)this.name));
        }

        @Override
        public final int compareTo(Identity identity) {
            String string;
            String string2 = identity.lang == null ? "" : identity.lang;
            String string3 = this.lang == null ? "" : this.lang;
            String string4 = identity.type == null ? "" : identity.type;
            String string5 = string = this.type == null ? "" : this.type;
            if (this.category.equals(identity.category)) {
                if (string.equals(string4)) {
                    if (string3.equals(string2)) {
                        return 0;
                    }
                    return string3.compareTo(string2);
                }
                return string.compareTo(string4);
            }
            return this.category.compareTo(identity.category);
        }

        public final String toString() {
            return this.toXML().toString();
        }
    }
}

