/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.provider;

import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;

public class VCardProvider
extends IQProvider<VCard> {
    private static final String[] ADR = new String[]{"POSTAL", "PARCEL", "DOM", "INTL", "PREF", "POBOX", "EXTADR", "STREET", "LOCALITY", "REGION", "PCODE", "CTRY", "FF"};
    private static final String[] TEL = new String[]{"VOICE", "FAX", "PAGER", "MSG", "CELL", "VIDEO", "BBS", "MODEM", "ISDN", "PCS", "PREF"};

    /*
     * Enabled aggressive block sorting
     */
    public VCard parse(XmlPullParser xmlPullParser, int n, XmlEnvironment object) {
        object = new VCard();
        String string = null;
        block25: while (true) {
            Object object2 = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object2.ordinal()]) {
                case 1: {
                    string = xmlPullParser.getName();
                    switch (string) {
                        case "N": {
                            VCardProvider.parseName(xmlPullParser, (VCard)((Object)object));
                            break block0;
                        }
                        case "ORG": {
                            VCardProvider.parseOrg(xmlPullParser, (VCard)((Object)object));
                            break block0;
                        }
                        case "TEL": {
                            VCardProvider.parseTel(xmlPullParser, (VCard)((Object)object));
                            break block0;
                        }
                        case "ADR": {
                            VCardProvider.parseAddress(xmlPullParser, (VCard)((Object)object));
                            break block0;
                        }
                        case "EMAIL": {
                            VCardProvider.parseEmail(xmlPullParser, (VCard)((Object)object));
                            break block0;
                        }
                        case "NICKNAME": {
                            ((VCard)((Object)object)).setNickName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "JABBERID": {
                            ((VCard)((Object)object)).setJabberId(xmlPullParser.nextText());
                            break block0;
                        }
                        case "PHOTO": {
                            VCardProvider.parsePhoto(xmlPullParser, (VCard)((Object)object));
                        }
                    }
                    continue block25;
                }
                case 2: {
                    if (n + 1 != xmlPullParser.getDepth()) break;
                    object2 = xmlPullParser.getText();
                    ((VCard)((Object)object)).setField(string, (String)object2);
                    continue block25;
                }
                case 3: {
                    if (xmlPullParser.getDepth() == n) break block25;
                }
            }
        }
        return object;
    }

    private static void parseAddress(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = true;
        block4: while (true) {
            Object object = xmlPullParser.next();
            switch (object) {
                case START_ELEMENT: {
                    object = xmlPullParser.getName();
                    if ("HOME".equals(object)) {
                        bl = false;
                        continue block4;
                    }
                    String[] stringArray = ADR;
                    int n2 = ADR.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) continue block4;
                        String string = stringArray[n3];
                        if (string.equals(object)) {
                            if (bl) {
                                vCard.setAddressFieldWork((String)object, xmlPullParser.nextText());
                            } else {
                                vCard.setAddressFieldHome((String)object, xmlPullParser.nextText());
                            }
                        }
                        ++n3;
                    }
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    private static void parseTel(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = true;
        String string = null;
        block4: while (true) {
            Object object = xmlPullParser.next();
            switch (object) {
                case START_ELEMENT: {
                    object = xmlPullParser.getName();
                    if ("HOME".equals(object)) {
                        bl = false;
                        continue block4;
                    }
                    if ("NUMBER".equals(object)) {
                        if (StringUtils.isNullOrEmpty(string)) {
                            string = "VOICE";
                        }
                        if (bl) {
                            vCard.setPhoneWork(string, xmlPullParser.nextText());
                            continue block4;
                        }
                        vCard.setPhoneHome(string, xmlPullParser.nextText());
                        continue block4;
                    }
                    String[] stringArray = TEL;
                    int n2 = TEL.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) continue block4;
                        String string2 = stringArray[n3];
                        if (string2.equals(object)) {
                            string = object;
                        }
                        ++n3;
                    }
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseOrg(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        block12: while (true) {
            Object object = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "ORGNAME": {
                            vCard.setOrganization(xmlPullParser.nextText());
                            break block0;
                        }
                        case "ORGUNIT": {
                            vCard.setOrganizationUnit(xmlPullParser.nextText());
                        }
                    }
                    continue block12;
                }
                case 3: {
                    if (xmlPullParser.getDepth() == n) break block12;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseEmail(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        block12: while (true) {
            Object object = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "WORK": {
                            bl = true;
                            break block0;
                        }
                        case "USERID": {
                            if (bl) {
                                vCard.setEmailWork(xmlPullParser.nextText());
                                break block0;
                            }
                            vCard.setEmailHome(xmlPullParser.nextText());
                        }
                    }
                    continue block12;
                }
                case 3: {
                    if (xmlPullParser.getDepth() == n) break block12;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseName(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        block18: while (true) {
            Object object = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "FAMILY": {
                            vCard.setLastName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "GIVEN": {
                            vCard.setFirstName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "MIDDLE": {
                            vCard.setMiddleName(xmlPullParser.nextText());
                            break block0;
                        }
                        case "PREFIX": {
                            vCard.setPrefix(xmlPullParser.nextText());
                            break block0;
                        }
                        case "SUFFIX": {
                            vCard.setSuffix(xmlPullParser.nextText());
                        }
                    }
                    continue block18;
                }
                case 3: {
                    if (xmlPullParser.getDepth() == n) break block18;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePhoto(XmlPullParser xmlPullParser, VCard vCard) {
        int n = xmlPullParser.getDepth();
        String string = null;
        String string2 = null;
        block12: while (true) {
            Object object = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "BINVAL": {
                            string = xmlPullParser.nextText();
                            break block0;
                        }
                        case "TYPE": {
                            string2 = xmlPullParser.nextText();
                        }
                    }
                    continue block12;
                }
                case 3: {
                    if (xmlPullParser.getDepth() == n) break block12;
                }
            }
        }
        if (string != null && string2 != null) {
            vCard.setAvatar(string, string2);
            return;
        }
    }
}

