/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

final class UnreleasableByteBuf
extends WrappedByteBuf {
    private SwappedByteBuf swappedBuf;

    UnreleasableByteBuf(ByteBuf byteBuf) {
        super(byteBuf instanceof UnreleasableByteBuf ? byteBuf.unwrap() : byteBuf);
    }

    @Override
    public final ByteBuf order(ByteOrder object) {
        if (ObjectUtil.checkNotNull((Object)object, (String)"endianness") == ((ByteBuf)this).order()) {
            return this;
        }
        object = this.swappedBuf;
        if (object == null) {
            object = new SwappedByteBuf(this);
            this.swappedBuf = object;
        }
        return object;
    }

    @Override
    public final ByteBuf asReadOnly() {
        if (this.buf.isReadOnly()) {
            return this;
        }
        return new UnreleasableByteBuf(this.buf.asReadOnly());
    }

    @Override
    public final ByteBuf readSlice(int n) {
        return new UnreleasableByteBuf(this.buf.readSlice(n));
    }

    @Override
    public final ByteBuf readRetainedSlice(int n) {
        return ((ByteBuf)this).readSlice(n);
    }

    @Override
    public final ByteBuf slice() {
        return new UnreleasableByteBuf(this.buf.slice());
    }

    @Override
    public final ByteBuf retainedSlice() {
        return ((ByteBuf)this).slice();
    }

    @Override
    public final ByteBuf slice(int n, int n2) {
        return new UnreleasableByteBuf(this.buf.slice(n, n2));
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        return ((ByteBuf)this).slice(n, n2);
    }

    @Override
    public final ByteBuf duplicate() {
        return new UnreleasableByteBuf(this.buf.duplicate());
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).duplicate();
    }

    @Override
    public final ByteBuf retain(int n) {
        return this;
    }

    @Override
    public final ByteBuf retain() {
        return this;
    }

    @Override
    public final ByteBuf touch() {
        return this;
    }

    @Override
    public final ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public final boolean release() {
        return false;
    }

    @Override
    public final boolean release(int n) {
        return false;
    }
}

