/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.OverscrollEffect;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollableNode;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010#\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0013\u0010)\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\f\u0010,\u001a\u00020%*\u00020-H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Landroidx/compose/foundation/gestures/ScrollableElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/foundation/gestures/ScrollableNode;", "state", "Landroidx/compose/foundation/gestures/ScrollableState;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "overscrollEffect", "Landroidx/compose/foundation/OverscrollEffect;", "enabled", "", "reverseDirection", "flingBehavior", "Landroidx/compose/foundation/gestures/FlingBehavior;", "interactionSource", "Landroidx/compose/foundation/interaction/MutableInteractionSource;", "bringIntoViewSpec", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "<init>", "(Landroidx/compose/foundation/gestures/ScrollableState;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/foundation/OverscrollEffect;ZZLandroidx/compose/foundation/gestures/FlingBehavior;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)V", "getState", "()Landroidx/compose/foundation/gestures/ScrollableState;", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "getOverscrollEffect", "()Landroidx/compose/foundation/OverscrollEffect;", "getEnabled", "()Z", "getReverseDirection", "getFlingBehavior", "()Landroidx/compose/foundation/gestures/FlingBehavior;", "getInteractionSource", "()Landroidx/compose/foundation/interaction/MutableInteractionSource;", "getBringIntoViewSpec", "()Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "create", "update", "", "node", "hashCode", "", "equals", "other", "", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "foundation"})
final class ScrollableElement
extends ModifierNodeElement<ScrollableNode> {
    private final ScrollableState state;
    private final Orientation orientation;
    private final OverscrollEffect overscrollEffect;
    private final boolean enabled;
    private final boolean reverseDirection;
    private final FlingBehavior flingBehavior;
    private final MutableInteractionSource interactionSource;
    private final BringIntoViewSpec bringIntoViewSpec;

    public ScrollableElement(ScrollableState scrollableState, Orientation orientation, OverscrollEffect overscrollEffect, boolean bl, boolean bl2, FlingBehavior flingBehavior, MutableInteractionSource mutableInteractionSource, BringIntoViewSpec bringIntoViewSpec) {
        Intrinsics.checkNotNullParameter((Object)scrollableState, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"");
        this.state = scrollableState;
        this.orientation = orientation;
        this.overscrollEffect = overscrollEffect;
        this.enabled = bl;
        this.reverseDirection = bl2;
        this.flingBehavior = flingBehavior;
        this.interactionSource = mutableInteractionSource;
        this.bringIntoViewSpec = bringIntoViewSpec;
    }

    public final ScrollableState getState() {
        return this.state;
    }

    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final OverscrollEffect getOverscrollEffect() {
        return this.overscrollEffect;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final boolean getReverseDirection() {
        return this.reverseDirection;
    }

    public final FlingBehavior getFlingBehavior() {
        return this.flingBehavior;
    }

    public final MutableInteractionSource getInteractionSource() {
        return this.interactionSource;
    }

    public final BringIntoViewSpec getBringIntoViewSpec() {
        return this.bringIntoViewSpec;
    }

    public final ScrollableNode create() {
        return new ScrollableNode(this.state, this.overscrollEffect, this.flingBehavior, this.orientation, this.enabled, this.reverseDirection, this.interactionSource, this.bringIntoViewSpec);
    }

    public final void update(ScrollableNode scrollableNode) {
        Intrinsics.checkNotNullParameter((Object)scrollableNode, (String)"");
        scrollableNode.update(this.state, this.orientation, this.overscrollEffect, this.enabled, this.reverseDirection, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
    }

    public final int hashCode() {
        int n = this.state.hashCode();
        n = n * 31 + this.orientation.hashCode();
        OverscrollEffect overscrollEffect = this.overscrollEffect;
        n = n * 31 + (overscrollEffect != null ? overscrollEffect.hashCode() : 0);
        n = n * 31 + Boolean.hashCode(this.enabled);
        n = n * 31 + Boolean.hashCode(this.reverseDirection);
        FlingBehavior flingBehavior = this.flingBehavior;
        n = n * 31 + (flingBehavior != null ? flingBehavior.hashCode() : 0);
        MutableInteractionSource mutableInteractionSource = this.interactionSource;
        n = n * 31 + (mutableInteractionSource != null ? mutableInteractionSource.hashCode() : 0);
        BringIntoViewSpec bringIntoViewSpec = this.bringIntoViewSpec;
        n = n * 31 + (bringIntoViewSpec != null ? bringIntoViewSpec.hashCode() : 0);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ScrollableElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)((ScrollableElement)((Object)object)).state)) {
            return false;
        }
        if (this.orientation != ((ScrollableElement)((Object)object)).orientation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.overscrollEffect, (Object)((ScrollableElement)((Object)object)).overscrollEffect)) {
            return false;
        }
        if (this.enabled != ((ScrollableElement)((Object)object)).enabled) {
            return false;
        }
        if (this.reverseDirection != ((ScrollableElement)((Object)object)).reverseDirection) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.flingBehavior, (Object)((ScrollableElement)((Object)object)).flingBehavior)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.interactionSource, (Object)((ScrollableElement)((Object)object)).interactionSource)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bringIntoViewSpec, (Object)((ScrollableElement)((Object)object)).bringIntoViewSpec);
    }

    public final void inspectableProperties(InspectorInfo inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)inspectorInfo, (String)"");
        inspectorInfo.setName("scrollable");
        inspectorInfo.getProperties().set("orientation", (Object)this.orientation);
        inspectorInfo.getProperties().set("state", (Object)this.state);
        inspectorInfo.getProperties().set("overscrollEffect", (Object)this.overscrollEffect);
        inspectorInfo.getProperties().set("enabled", (Object)this.enabled);
        inspectorInfo.getProperties().set("reverseDirection", (Object)this.reverseDirection);
        inspectorInfo.getProperties().set("flingBehavior", (Object)this.flingBehavior);
        inspectorInfo.getProperties().set("interactionSource", (Object)this.interactionSource);
        inspectorInfo.getProperties().set("bringIntoViewSpec", (Object)this.bringIntoViewSpec);
    }
}

