/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.markers.KMutableListIterator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001c\u001a\u00020\u0015H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/snapshots/StateListIterator;", "T", "", "list", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "offset", "", "<init>", "(Landroidx/compose/runtime/snapshots/SnapshotStateList;I)V", "getList", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "index", "lastRequested", "structure", "hasPrevious", "", "nextIndex", "previous", "()Ljava/lang/Object;", "previousIndex", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "next", "remove", "set", "validateModification", "runtime"})
public final class StateListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    private final SnapshotStateList<T> list;
    private int index;
    private int lastRequested;
    private int structure;
    public static final int $stable = 8;

    public StateListIterator(SnapshotStateList<T> snapshotStateList, int n2) {
        this.list = snapshotStateList;
        this.index = n2 - 1;
        this.lastRequested = -1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    public final SnapshotStateList<T> getList() {
        return this.list;
    }

    @Override
    public final boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public final int nextIndex() {
        return this.index + 1;
    }

    @Override
    public final T previous() {
        this.validateModification();
        SnapshotStateListKt.access$validateRange(this.index, this.list.size());
        this.lastRequested = this.index;
        T t = this.list.get(this.index);
        int n2 = this.index;
        this.index = n2 + -1;
        return t;
    }

    @Override
    public final int previousIndex() {
        return this.index;
    }

    @Override
    public final void add(T t) {
        this.validateModification();
        this.list.add(this.index + 1, t);
        this.lastRequested = -1;
        int n2 = this.index;
        this.index = n2 + 1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    @Override
    public final boolean hasNext() {
        return this.index < this.list.size() - 1;
    }

    @Override
    public final T next() {
        int n2;
        this.validateModification();
        this.lastRequested = n2 = this.index + 1;
        SnapshotStateListKt.access$validateRange(n2, this.list.size());
        T t = this.list.get(n2);
        this.index = n2;
        return t;
    }

    @Override
    public final void remove() {
        this.validateModification();
        this.list.remove(this.lastRequested);
        int n2 = this.index;
        this.index = n2 + -1;
        this.lastRequested = -1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    @Override
    public final void set(T t) {
        this.validateModification();
        if (this.lastRequested < 0) {
            SnapshotStateListKt.access$invalidIteratorSet();
            throw new KotlinNothingValueException();
        }
        this.list.set(this.lastRequested, t);
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    private final void validateModification() {
        if (SnapshotStateListKt.getStructure(this.list) != this.structure) {
            throw new ConcurrentModificationException();
        }
    }
}

