/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.util.Async;

public class ScheduledAction
implements Delayed {
    private final Runnable action;
    final Date releaseTime;
    final SmackReactor smackReactor;
    final Kind kind;

    ScheduledAction(Runnable runnable, Date date, SmackReactor smackReactor, Kind kind) {
        this.action = runnable;
        this.releaseTime = date;
        this.smackReactor = smackReactor;
        this.kind = kind;
    }

    public boolean cancel() {
        return this.smackReactor.cancel(this);
    }

    public boolean isDue() {
        Date date = new Date();
        return date.after(this.releaseTime);
    }

    public long getTimeToDueMillis() {
        long l = System.currentTimeMillis();
        return this.releaseTime.getTime() - l;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        long l = this.getDelay(TimeUnit.MILLISECONDS);
        long l2 = delayed.getDelay(TimeUnit.MILLISECONDS);
        return Long.compare(l, l2);
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        long l = this.getTimeToDueMillis();
        return timeUnit.convert(l, TimeUnit.MILLISECONDS);
    }

    void run() {
        switch (this.kind) {
            case NonBlocking: {
                this.action.run();
                return;
            }
            case Blocking: {
                Async.go(() -> this.action.run());
            }
        }
    }

    static enum Kind {
        NonBlocking,
        Blocking;

    }
}

