/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ScheduledAction;

public class SmackReactor {
    private static final Logger LOGGER = Logger.getLogger(SmackReactor.class.getName());
    private static final int DEFAULT_REACTOR_THREAD_COUNT = 2;
    private static final int PENDING_SET_INTEREST_OPS_MAX_BATCH_SIZE = 1024;
    private static SmackReactor INSTANCE;
    private final Selector selector;
    private final String reactorName;
    private final List<Reactor> reactorThreads = Collections.synchronizedList(new ArrayList());
    private final DelayQueue<ScheduledAction> scheduledActions = new DelayQueue();
    private final Lock registrationLock = new ReentrantLock();
    private final Semaphore actionsSemaphore = new Semaphore(-1, false);
    private final Queue<SelectionKey> pendingSelectionKeys = new ConcurrentLinkedQueue<SelectionKey>();
    private final Queue<SetInterestOps> pendingSetInterestOps = new ConcurrentLinkedQueue<SetInterestOps>();

    static synchronized SmackReactor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SmackReactor("DefaultReactor");
        }
        return INSTANCE;
    }

    SmackReactor(String string) {
        this.reactorName = string;
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.setReactorThreadCount(2);
    }

    public SelectionKey registerWithSelector(SelectableChannel object, int n, ChannelSelectedCallback object2) {
        object2 = new SelectionKeyAttachment((ChannelSelectedCallback)object2);
        this.registrationLock.lock();
        try {
            this.selector.wakeup();
            object = ((SelectableChannel)object).register(this.selector, n, object2);
            return object;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    public void setInterestOps(SelectionKey object, int n) {
        object = new SetInterestOps((SelectionKey)object, n);
        this.pendingSetInterestOps.add((SetInterestOps)object);
        this.selector.wakeup();
    }

    ScheduledAction schedule(Runnable object, long l, TimeUnit timeUnit, ScheduledAction.Kind kind) {
        long l2 = System.currentTimeMillis() + timeUnit.toMillis(l);
        Date date = new Date(l2);
        object = new ScheduledAction((Runnable)object, date, this, kind);
        this.scheduledActions.add((ScheduledAction)object);
        this.selector.wakeup();
        return object;
    }

    boolean cancel(ScheduledAction scheduledAction) {
        return this.scheduledActions.remove(scheduledAction);
    }

    private static void handleSelectedKeys(Collection<SelectionKey> object) {
        object = object.iterator();
        while (object.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)object.next();
            SelectableChannel selectableChannel = selectionKey.channel();
            Object object2 = (SelectionKeyAttachment)selectionKey.attachment();
            object2 = ((SelectionKeyAttachment)object2).channelSelectedCallback;
            object2.onChannelSelected(selectableChannel, selectionKey);
        }
    }

    public void setReactorThreadCount(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Must have at least two reactor threads, but you requested " + n);
        }
        List<Reactor> list = this.reactorThreads;
        synchronized (list) {
            if ((n -= this.reactorThreads.size()) > 0) {
                for (int j = 0; j < n; ++j) {
                    Reactor reactor = new Reactor();
                    reactor.setDaemon(true);
                    reactor.setName("Smack " + this.reactorName + " Thread #" + j);
                    this.reactorThreads.add(reactor);
                    reactor.start();
                }
                this.actionsSemaphore.release(n);
            } else {
                this.selector.wakeup();
            }
            return;
        }
    }

    public static final class SelectionKeyAttachment {
        private final ChannelSelectedCallback channelSelectedCallback;
        private final AtomicBoolean reactorThreadRacing = new AtomicBoolean();

        private SelectionKeyAttachment(ChannelSelectedCallback channelSelectedCallback) {
            this.channelSelectedCallback = channelSelectedCallback;
        }

        private void setRacing() {
            this.reactorThreadRacing.lazySet(true);
        }

        public final void resetReactorThreadRacing() {
            this.reactorThreadRacing.set(false);
        }

        public final boolean isReactorThreadRacing() {
            return this.reactorThreadRacing.get();
        }
    }

    public static interface ChannelSelectedCallback {
        public void onChannelSelected(SelectableChannel var1, SelectionKey var2);
    }

    private class Reactor
    extends Thread {
        private volatile long shutdownRequestTimestamp = -1L;

        private Reactor() {
        }

        @Override
        public void run() {
            block6: {
                try {
                    this.reactorLoop();
                    if (this.shutdownRequestTimestamp <= 0L) break block6;
                }
                catch (Throwable throwable) {
                    if (this.shutdownRequestTimestamp > 0L) {
                        long l = System.currentTimeMillis() - this.shutdownRequestTimestamp;
                        LOGGER.info(this + " shut down after " + l + "ms");
                    } else {
                        boolean bl = SmackReactor.this.reactorThreads.remove(this);
                        assert (bl);
                    }
                    throw throwable;
                }
                long l = System.currentTimeMillis() - this.shutdownRequestTimestamp;
                LOGGER.info(this + " shut down after " + l + "ms");
                return;
            }
            boolean bl = SmackReactor.this.reactorThreads.remove(this);
            assert (bl);
        }

        private void reactorLoop() {
            while (this.shutdownRequestTimestamp < 0L) {
                this.handleScheduledActionsOrPerformSelect();
                this.handlePendingSelectionKeys();
            }
        }

        private void handleScheduledActionsOrPerformSelect() {
            ArrayList<SelectionKey> arrayList;
            int n;
            ScheduledAction scheduledAction = null;
            boolean bl = SmackReactor.this.actionsSemaphore.tryAcquire();
            if (bl) {
                try {
                    scheduledAction = (ScheduledAction)SmackReactor.this.scheduledActions.poll();
                }
                finally {
                    SmackReactor.this.actionsSemaphore.release();
                }
            }
            if (scheduledAction != null) {
                scheduledAction.run();
                return;
            }
            Selector selector = SmackReactor.this.selector;
            synchronized (selector) {
                Set<SelectionKey> set;
                block22: {
                    long l;
                    set = (ScheduledAction)SmackReactor.this.scheduledActions.peek();
                    if (set == null) {
                        l = 0L;
                    } else {
                        l = ((ScheduledAction)((Object)set)).getTimeToDueMillis();
                        if (l <= 0L) {
                            return;
                        }
                    }
                    n = 0;
                    while ((set = (SetInterestOps)SmackReactor.this.pendingSetInterestOps.poll()) != null) {
                        this.setInterestOpsCancelledKeySafe(((SetInterestOps)((Object)set)).selectionKey, ((SetInterestOps)((Object)set)).interestOps);
                        if (n++ < 1024) continue;
                        SmackReactor.this.selector.wakeup();
                        break;
                    }
                    SmackReactor.this.registrationLock.lock();
                    SmackReactor.this.registrationLock.unlock();
                    try {
                        n = SmackReactor.this.selector.select(l);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "IOException while using select()", iOException);
                        return;
                    }
                    if (n != 0) break block22;
                    return;
                }
                set = SmackReactor.this.selector.selectedKeys();
                for (SelectionKey selectionKey : set) {
                    SelectionKeyAttachment object = (SelectionKeyAttachment)selectionKey.attachment();
                    object.setRacing();
                }
                for (SelectionKey selectionKey : set) {
                    this.setInterestOpsCancelledKeySafe(selectionKey, 0);
                }
                arrayList = new ArrayList<SelectionKey>(set.size());
                arrayList.addAll(set);
                set.clear();
            }
            int n2 = arrayList.size();
            int n3 = SmackReactor.this.reactorThreads.size();
            int n4 = n2 > n3 ? n2 / n3 : n2;
            Level level = Level.FINE;
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, "New selected key count: " + n + ". Total selected key count " + n2 + ". My key count: " + n4 + ". Current reactor thread count: " + n3);
            }
            ArrayList<SelectionKey> arrayList2 = new ArrayList<SelectionKey>(n4);
            Iterator iterator = arrayList.iterator();
            for (int j = 0; j < n4; ++j) {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                arrayList2.add(selectionKey);
            }
            while (iterator.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                SmackReactor.this.pendingSelectionKeys.add(selectionKey);
            }
            if (n2 - n4 > 0) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(arrayList2);
        }

        private void handlePendingSelectionKeys() {
            SelectionKey selectionKey;
            int n = SmackReactor.this.pendingSelectionKeys.size();
            if (n == 0) {
                return;
            }
            int n2 = SmackReactor.this.reactorThreads.size();
            if ((n /= n2) == 0) {
                n = 1;
            }
            ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>(n);
            for (int j = 0; j < n && (selectionKey = (SelectionKey)SmackReactor.this.pendingSelectionKeys.poll()) != null; ++j) {
                arrayList.add(selectionKey);
            }
            if (!SmackReactor.this.pendingSelectionKeys.isEmpty()) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(arrayList);
        }

        private void setInterestOpsCancelledKeySafe(SelectionKey selectionKey, int n) {
            try {
                selectionKey.interestOps(n);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                Level level = Level.FINER;
                if (LOGGER.isLoggable(level)) {
                    LOGGER.log(level, "Key '" + selectionKey + "' has been cancelled", cancelledKeyException);
                }
                return;
            }
        }

        void requestShutdown() {
            this.shutdownRequestTimestamp = System.currentTimeMillis();
        }
    }

    private static final class SetInterestOps {
        private final SelectionKey selectionKey;
        private final int interestOps;

        private SetInterestOps(SelectionKey selectionKey, int n) {
            this.selectionKey = selectionKey;
            this.interestOps = n;
        }
    }
}

