/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J(\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0016J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020\bH\u0016J\u0014\u0010+\u001a\u00020\b2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0016J\b\u0010.\u001a\u00020\u001eH\u0016J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e002\n\u00101\u001a\u0006\u0012\u0002\b\u0003022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001e00H\u0016J\u0010\u00109\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0014\u0010\u0017\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0014\u0010\u0019\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u0014\u0010\u001b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\n\u00a8\u0006;"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnUpdate", "getSupportsOnUpdate", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "createDatabase", "", "name", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resolveRefOptionFromJdbc", "refOption", "", "sequences", "setSchema", "Companion", "exposed-core"})
public class OracleDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsOnUpdate;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsRestrictReferenceOption;

    public OracleDialect() {
        super(Companion.getDialectName(), OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return this.supportsOnUpdate;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        return true;
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return "DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(string2);
    }

    @Override
    public List<String> modifyColumn(Column<?> object, ColumnDiff object2) {
        Object object3;
        Object object4;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Object object5 = object4 = (Iterable)super.modifyColumn((Column<?>)object, (ColumnDiff)object2);
        Iterable iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
        object5 = object5.iterator();
        while (object5.hasNext()) {
            Object e = object5.next();
            String string = (String)e;
            object3 = iterable;
            object3.add(StringsKt.replace$default((String)string, (String)"MODIFY COLUMN", (String)"MODIFY", (boolean)false, (int)4, null));
        }
        object5 = (List)iterable;
        if (!((ColumnDiff)object2).getNullability()) {
            object4 = ((ExpressionWithColumnType)object).getColumnType().getNullable() ? "NULL " : "NOT NULL";
            object = (Iterable)object5;
            iterable = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            for (String string : iterable) {
                object2 = string;
                object3 = object;
                object3.add(StringsKt.replace$default((String)object2, (String)object4, (String)"", (boolean)false, (int)4, null));
            }
            return (List)object;
        }
        return object5;
    }

    @Override
    public String createDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String listDatabases() {
        throw new IllegalStateException("This operation is not supported by Oracle dialect".toString());
    }

    @Override
    public String dropDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "DROP DATABASE";
    }

    @Override
    public String setSchema(Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "ALTER SESSION SET CURRENT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    public String createSchema(Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "CREATE USER ";
        stringArray2[1] = schema.getIdentifier();
        StringsKt.append((StringBuilder)stringBuilder2, (String[])stringArray2);
        String[] stringArray3 = new String[2];
        stringArray2 = stringArray3;
        stringArray3[0] = " IDENTIFIED BY ";
        stringArray2[1] = schema.getPassword();
        StringsKt.append((StringBuilder)stringBuilder2, (String[])stringArray2);
        SchemaKt.appendIfNotNull(stringBuilder2, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull(stringBuilder2, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull(stringBuilder2, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull(stringBuilder2, " ON ", schema.getOn());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String dropSchema(Schema schema, boolean bl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "DROP USER ";
        stringArray2[1] = schema.getIdentifier();
        StringsKt.append((StringBuilder)stringBuilder, (String[])stringArray2);
        if (bl) {
            stringBuilder2.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public ReferenceOption resolveRefOptionFromJdbc(int n) {
        switch (n) {
            case 0: {
                return ReferenceOption.CASCADE;
            }
            case 2: {
                return ReferenceOption.SET_NULL;
            }
            case 1: {
                return ReferenceOption.NO_ACTION;
            }
        }
        return DatabaseDialectKt.getCurrentDialect().getDefaultReferenceOption();
    }

    @Override
    public List<String> sequences() {
        List list = new ArrayList();
        Transaction.exec$default(TransactionManager.Companion.current(), "SELECT SEQUENCE_NAME FROM USER_SEQUENCES", null, null, (Function1)new Function1<ResultSet, Unit>((List<String>)list){
            final /* synthetic */ List<String> $sequences;
            {
                this.$sequences = list;
                super(1);
            }

            public final void invoke(ResultSet resultSet) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                while (resultSet.next()) {
                    String string = resultSet.getString("SEQUENCE_NAME");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    this.$sequences.add(string);
                }
            }
        }, 6, null);
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("Oracle");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

