/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;
    private final ChannelHandler http2MultiplexHandler;

    public Http2ClientUpgradeCodec(Http2FrameCodec http2FrameCodec, ChannelHandler channelHandler) {
        this(null, http2FrameCodec, channelHandler);
    }

    public Http2ClientUpgradeCodec(String string, Http2FrameCodec http2FrameCodec, ChannelHandler channelHandler) {
        this(string, http2FrameCodec, channelHandler, null);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler http2ConnectionHandler) {
        this(null, http2ConnectionHandler);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler http2ConnectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this(null, http2ConnectionHandler, http2MultiplexHandler);
    }

    public Http2ClientUpgradeCodec(String string, Http2ConnectionHandler http2ConnectionHandler) {
        Http2ConnectionHandler http2ConnectionHandler2 = http2ConnectionHandler;
        this(string, http2ConnectionHandler2, (ChannelHandler)http2ConnectionHandler2, null);
    }

    public Http2ClientUpgradeCodec(String string, Http2ConnectionHandler http2ConnectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        Http2ConnectionHandler http2ConnectionHandler2 = http2ConnectionHandler;
        this(string, http2ConnectionHandler2, (ChannelHandler)http2ConnectionHandler2, http2MultiplexHandler);
    }

    private Http2ClientUpgradeCodec(String string, Http2ConnectionHandler http2ConnectionHandler, ChannelHandler channelHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this.handlerName = string;
        this.connectionHandler = (Http2ConnectionHandler)ObjectUtil.checkNotNull((Object)http2ConnectionHandler, (String)"connectionHandler");
        this.upgradeToHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)channelHandler, (String)"upgradeToHandler");
        this.http2MultiplexHandler = http2MultiplexHandler;
    }

    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext object, HttpRequest httpRequest) {
        object = this.getSettingsHeaderValue((ChannelHandlerContext)object);
        httpRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, object);
        return UPGRADE_HEADERS;
    }

    public void upgradeTo(ChannelHandlerContext channelHandlerContext, FullHttpResponse object) {
        try {
            channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), this.handlerName, this.upgradeToHandler);
            if (this.http2MultiplexHandler != null) {
                object = channelHandlerContext.pipeline().context((ChannelHandler)this.connectionHandler).name();
                channelHandlerContext.pipeline().addAfter((String)object, null, this.http2MultiplexHandler);
            }
            this.connectionHandler.onHttpClientUpgrade();
            return;
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught((Throwable)http2Exception);
            channelHandlerContext.close();
            return;
        }
    }

    private CharSequence getSettingsHeaderValue(ChannelHandlerContext object) {
        ByteBuf byteBuf = null;
        ByteBuf byteBuf2 = null;
        try {
            Http2Settings http2Settings2 = this.connectionHandler.decoder().localSettings();
            int n = 6 * http2Settings2.size();
            byteBuf = object.alloc().buffer(n);
            for (Http2Settings http2Settings2 : http2Settings2.entries()) {
                byteBuf.writeChar((int)http2Settings2.key());
                byteBuf.writeInt(((Long)http2Settings2.value()).intValue());
            }
            byteBuf2 = Base64.encode((ByteBuf)byteBuf, (Base64Dialect)Base64Dialect.URL_SAFE);
            object = byteBuf2.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(byteBuf);
            ReferenceCountUtil.release(byteBuf2);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)byteBuf);
        ReferenceCountUtil.release((Object)byteBuf2);
        return object;
    }
}

