/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.buffer.SizeClasses;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger;
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final boolean DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private static final int CACHE_NOT_USED = 0;
    private final Runnable trimTask = new Runnable(){

        @Override
        public void run() {
            PooledByteBufAllocator.this.trimCurrentThreadCache();
        }
    };
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n, int n2, int n3, int n4) {
        this(false, n, n2, n3, n4);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4) {
        this(bl, n, n2, n3, n4, 0, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(bl, n, n2, n3, n4, n6, n7, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this(bl, n, n2, n3, n4, n6, n7, bl2);
    }

    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this(bl, n, n2, n3, n4, n5, n6, bl2, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2, int n8) {
        this(bl, n, n2, n3, n4, n6, n7, bl2, n8);
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        super(bl);
        void var3_6;
        void arrayList;
        void sizeClasses;
        int n8;
        void var9_16;
        void heapArena;
        int n9;
        void var8_15;
        this.threadCache = new PoolThreadLocalCache((boolean)var8_15);
        this.smallCacheSize = n9;
        this.normalCacheSize = heapArena;
        if (var9_16 != false) {
            if (!PlatformDependent.hasAlignDirectByteBuffer()) {
                throw new UnsupportedOperationException("Buffer alignment is not supported. Either Unsafe or ByteBuffer.alignSlice() must be available.");
            }
            n8 = (int)PlatformDependent.align((long)n8, (int)var9_16);
        }
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(n8, (int)sizeClasses);
        ObjectUtil.checkPositiveOrZero((int)arrayList, (String)"nHeapArena");
        ObjectUtil.checkPositiveOrZero((int)var3_6, (String)"nDirectArena");
        ObjectUtil.checkPositiveOrZero((int)var9_16, (String)"directMemoryCacheAlignment");
        if (var9_16 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        void v0 = var9_16;
        if ((v0 & -v0) != var9_16) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + (int)var9_16 + " (expected: power of two)");
        }
        int n10 = PooledByteBufAllocator.validateAndCalculatePageShifts(n8, (int)var9_16);
        if (arrayList > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray((int)arrayList);
            ArrayList<PoolArena.HeapArena> arrayList2 = new ArrayList<PoolArena.HeapArena>(this.heapArenas.length);
            SizeClasses sizeClasses2 = new SizeClasses(n8, n10, this.chunkSize, 0);
            for (n9 = 0; n9 < this.heapArenas.length; ++n9) {
                PoolArena.HeapArena directArena;
                this.heapArenas[n9] = directArena = new PoolArena.HeapArena(this, sizeClasses2);
                arrayList2.add(directArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList2);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (var3_6 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray((int)var3_6);
            ArrayList<PoolArena.DirectArena> arrayList3 = new ArrayList<PoolArena.DirectArena>(this.directArenas.length);
            SizeClasses sizeClasses3 = new SizeClasses(n8, n10, this.chunkSize, (int)var9_16);
            for (n9 = 0; n9 < this.directArenas.length; ++n9) {
                PoolArena.DirectArena directArena;
                this.directArenas[n9] = directArena = new PoolArena.DirectArena(this, sizeClasses3);
                arrayList3.add(directArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList3);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n) {
        return new PoolArena[n];
    }

    private static int validateAndCalculatePageShifts(int n, int n2) {
        if (n < 4096) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: 4096" + ')');
        }
        int n3 = n;
        if ((n3 & n3 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: power of 2)");
        }
        if (n < n2) {
            throw new IllegalArgumentException("Alignment cannot be greater than page size. Alignment: " + n2 + ", page size: " + n + '.');
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    private static int validateAndCalculateChunkSize(int n, int n2) {
        if (n2 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n2 + " (expected: 0-14)");
        }
        int n3 = n;
        for (int i = n2; i > 0; --i) {
            if (n3 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n, n2, 0x40000000));
            }
            n3 <<= 1;
        }
        return n3;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n, int n2) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n, n2) : (PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n, n2) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n, n2));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n, int n2) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n, n2) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n, n2) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n, n2));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultDisableCacheFinalizersForFastThreadLocalThreads() {
        return DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    @Deprecated
    public static int defaultTinyCacheSize() {
        return 0;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    private static boolean useCacheFinalizers(Thread thread) {
        if (!PooledByteBufAllocator.defaultDisableCacheFinalizersForFastThreadLocalThreads()) {
            return true;
        }
        return thread instanceof FastThreadLocalThread && ((FastThreadLocalThread)thread).willCleanupFastThreadLocals();
    }

    @Override
    public PooledByteBufAllocatorMetric metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    @Deprecated
    public int numThreadLocalCaches() {
        return Math.max(PooledByteBufAllocator.numThreadLocalCaches(this.heapArenas), PooledByteBufAllocator.numThreadLocalCaches(this.directArenas));
    }

    private static int numThreadLocalCaches(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return 0;
        }
        int n = 0;
        for (PoolArena<?> poolArena : poolArenaArray) {
            n += poolArena.numThreadCaches.get();
        }
        return n;
    }

    @Deprecated
    public int tinyCacheSize() {
        return 0;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    private static long usedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l += poolArena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l;
    }

    public final long pinnedHeapMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.heapArenas);
    }

    public final long pinnedDirectMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.directArenas);
    }

    private static long pinnedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l += poolArena.numPinnedBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l;
    }

    final PoolThreadCache threadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        if (!$assertionsDisabled && poolThreadCache == null) {
            throw new AssertionError();
        }
        return poolThreadCache;
    }

    public boolean trimCurrentThreadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.getIfExists();
        if (poolThreadCache != null) {
            poolThreadCache.trim();
            return true;
        }
        return false;
    }

    public String dumpStats() {
        int n;
        int n2 = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n2).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n2 > 0) {
            PoolArena<byte[]>[] poolArenaArray = this.heapArenas;
            int n3 = this.heapArenas.length;
            for (n = 0; n < n3; ++n) {
                PoolArena<byte[]> poolArena = poolArenaArray[n];
                stringBuilder.append(poolArena);
            }
        }
        n2 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n2).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n2 > 0) {
            PoolArena<ByteBuffer>[] poolArenaArray = this.directArenas;
            n = this.directArenas.length;
            for (int i = 0; i < n; ++i) {
                PoolArena<ByteBuffer> poolArena = poolArenaArray[i];
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    static {
        PooledByteBufAllocator.$assertionsDisabled = PooledByteBufAllocator.class.desiredAssertionStatus() == false;
        PooledByteBufAllocator.logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
        var0 = SystemPropertyUtil.getInt((String)"io.netty.allocator.directMemoryCacheAlignment", (int)0);
        var1_4 = SystemPropertyUtil.getInt((String)"io.netty.allocator.pageSize", (int)8192);
        var2_6 = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(var1_4, var0);
        }
        catch (Throwable v0) {
            var0_1 = v0;
            var2_6 = v0;
            var1_4 = 8192;
            var0 = 0;
        }
        PooledByteBufAllocator.DEFAULT_PAGE_SIZE = var1_4;
        PooledByteBufAllocator.DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = var0;
        var0 = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxOrder", (int)9);
        var1_5 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(PooledByteBufAllocator.DEFAULT_PAGE_SIZE, var0);
        }
        catch (Throwable v1) {
            var0_2 = v1;
            var1_5 = v1;
            var0 = 9;
        }
        PooledByteBufAllocator.DEFAULT_MAX_ORDER = var0;
        var0_3 = Runtime.getRuntime();
        var3_7 = NettyRuntime.availableProcessors() << 1;
        var4_8 = PooledByteBufAllocator.DEFAULT_PAGE_SIZE << PooledByteBufAllocator.DEFAULT_MAX_ORDER;
        PooledByteBufAllocator.DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty.allocator.numHeapArenas", (int)((int)Math.min((long)var3_7, var0_3.maxMemory() / (long)var4_8 / 2L / 3L))));
        PooledByteBufAllocator.DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty.allocator.numDirectArenas", (int)((int)Math.min((long)var3_7, PlatformDependent.maxDirectMemory() / (long)var4_8 / 2L / 3L))));
        PooledByteBufAllocator.DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty.allocator.smallCacheSize", (int)256);
        PooledByteBufAllocator.DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty.allocator.normalCacheSize", (int)64);
        PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxCachedBufferCapacity", (int)32768);
        PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt((String)"io.netty.allocator.cacheTrimInterval", (int)8192);
        if (!SystemPropertyUtil.contains((String)"io.netty.allocation.cacheTrimIntervalMillis")) ** GOTO lbl-1000
        PooledByteBufAllocator.logger.warn("-Dio.netty.allocation.cacheTrimIntervalMillis is deprecated, use -Dio.netty.allocator.cacheTrimIntervalMillis");
        if (!SystemPropertyUtil.contains((String)"io.netty.allocator.cacheTrimIntervalMillis")) {
            PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"io.netty.allocation.cacheTrimIntervalMillis", (long)0L);
        } else lbl-1000:
        // 2 sources

        {
            PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"io.netty.allocator.cacheTrimIntervalMillis", (long)0L);
        }
        PooledByteBufAllocator.DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.useCacheForAllThreads", (boolean)false);
        PooledByteBufAllocator.DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads", (boolean)false);
        PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt((String)"io.netty.allocator.maxCachedByteBuffersPerChunk", (int)1023);
        if (PooledByteBufAllocator.logger.isDebugEnabled()) {
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)PooledByteBufAllocator.DEFAULT_NUM_HEAP_ARENA);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)PooledByteBufAllocator.DEFAULT_NUM_DIRECT_ARENA);
            if (var2_6 == null) {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)PooledByteBufAllocator.DEFAULT_PAGE_SIZE);
            } else {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)PooledByteBufAllocator.DEFAULT_PAGE_SIZE, (Object)var2_6);
            }
            if (var1_5 == null) {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_ORDER);
            } else {
                PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_ORDER, (Object)var1_5);
            }
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(PooledByteBufAllocator.DEFAULT_PAGE_SIZE << PooledByteBufAllocator.DEFAULT_MAX_ORDER));
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)PooledByteBufAllocator.DEFAULT_SMALL_CACHE_SIZE);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)PooledByteBufAllocator.DEFAULT_NORMAL_CACHE_SIZE);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)PooledByteBufAllocator.DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)PooledByteBufAllocator.DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
            PooledByteBufAllocator.logger.debug("-Dio.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads: {}", (Object)PooledByteBufAllocator.DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS);
        }
        PooledByteBufAllocator.DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }

    private final class PoolThreadLocalCache
    extends FastThreadLocal<PoolThreadCache> {
        private final boolean useCacheForAllThreads;

        PoolThreadLocalCache(boolean bl) {
            this.useCacheForAllThreads = bl;
        }

        protected final synchronized PoolThreadCache initialValue() {
            PoolThreadLocalCache poolThreadLocalCache = this;
            Object object = poolThreadLocalCache.leastUsedArena(poolThreadLocalCache.PooledByteBufAllocator.this.heapArenas);
            PoolThreadLocalCache poolThreadLocalCache2 = this;
            PoolArena<ByteBuffer> poolArena = poolThreadLocalCache2.leastUsedArena(poolThreadLocalCache2.PooledByteBufAllocator.this.directArenas);
            Thread thread = Thread.currentThread();
            EventExecutor eventExecutor = ThreadExecutorMap.currentExecutor();
            if (this.useCacheForAllThreads || thread instanceof FastThreadLocalThread || eventExecutor != null) {
                object = new PoolThreadCache((PoolArena<byte[]>)object, poolArena, PooledByteBufAllocator.this.smallCacheSize, PooledByteBufAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL, PooledByteBufAllocator.useCacheFinalizers(thread));
                if (DEFAULT_CACHE_TRIM_INTERVAL_MILLIS > 0L && eventExecutor != null) {
                    eventExecutor.scheduleAtFixedRate(PooledByteBufAllocator.this.trimTask, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                }
                return object;
            }
            return new PoolThreadCache((PoolArena<byte[]>)object, poolArena, 0, 0, 0, 0, false);
        }

        protected final void onRemoval(PoolThreadCache poolThreadCache) {
            poolThreadCache.free(false);
        }

        private <T> PoolArena<T> leastUsedArena(PoolArena<T>[] poolArenaArray) {
            if (poolArenaArray == null || poolArenaArray.length == 0) {
                return null;
            }
            PoolArena<T> poolArena = poolArenaArray[0];
            if (poolArena.numThreadCaches.get() == 0) {
                return poolArena;
            }
            for (int i = 1; i < poolArenaArray.length; ++i) {
                PoolArena<T> poolArena2 = poolArenaArray[i];
                if (poolArena2.numThreadCaches.get() >= poolArena.numThreadCaches.get()) continue;
                poolArena = poolArena2;
            }
            return poolArena;
        }
    }
}

