/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private final UnpooledByteBufAllocatorMetric metric = new UnpooledByteBufAllocatorMetric();
    private final boolean disableLeakDetector;
    private final boolean noCleaner;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl) {
        this(bl, false);
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2) {
        this(bl, bl2, PlatformDependent.useDirectBufferNoCleaner());
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2, boolean bl3) {
        super(bl);
        this.disableLeakDetector = bl2;
        this.noCleaner = bl3 && PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor();
    }

    @Override
    protected final ByteBuf newHeapBuffer(int n, int n2) {
        if (PlatformDependent.hasUnsafe()) {
            return new InstrumentedUnpooledUnsafeHeapByteBuf(this, n, n2);
        }
        return new InstrumentedUnpooledHeapByteBuf(this, n, n2);
    }

    @Override
    protected final ByteBuf newDirectBuffer(int n, int n2) {
        UnpooledDirectByteBuf unpooledDirectByteBuf = PlatformDependent.hasUnsafe() ? (this.noCleaner ? new InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(this, n, n2) : new InstrumentedUnpooledUnsafeDirectByteBuf(this, n, n2)) : new InstrumentedUnpooledDirectByteBuf(this, n, n2);
        if (this.disableLeakDetector) {
            return unpooledDirectByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(unpooledDirectByteBuf);
    }

    @Override
    public final CompositeByteBuf compositeHeapBuffer(int n) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public final CompositeByteBuf compositeDirectBuffer(int n) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public final boolean isDirectBufferPooled() {
        return false;
    }

    @Override
    public final ByteBufAllocatorMetric metric() {
        return this.metric;
    }

    final void incrementDirect(int n) {
        this.metric.directCounter.add((long)n);
    }

    final void decrementDirect(int n) {
        this.metric.directCounter.add((long)(-n));
    }

    final void incrementHeap(int n) {
        this.metric.heapCounter.add((long)n);
    }

    final void decrementHeap(int n) {
        this.metric.heapCounter.add((long)(-n));
    }

    private static final class UnpooledByteBufAllocatorMetric
    implements ByteBufAllocatorMetric {
        final LongCounter directCounter = PlatformDependent.newLongCounter();
        final LongCounter heapCounter = PlatformDependent.newLongCounter();

        private UnpooledByteBufAllocatorMetric() {
        }

        @Override
        public final long usedHeapMemory() {
            return this.heapCounter.value();
        }

        @Override
        public final long usedDirectMemory() {
            return this.directCounter.value();
        }

        public final String toString() {
            return StringUtil.simpleClassName((Object)this) + "(usedHeapMemory: " + this.usedHeapMemory() + "; usedDirectMemory: " + this.usedDirectMemory() + ')';
        }
    }

    private static final class InstrumentedUnpooledDirectByteBuf
    extends UnpooledDirectByteBuf {
        InstrumentedUnpooledDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n, int n2) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n, n2);
        }

        @Override
        protected final ByteBuffer allocateDirect(int n) {
            ByteBuffer byteBuffer = super.allocateDirect(n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect(n);
        }
    }

    private static final class InstrumentedUnpooledUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        InstrumentedUnpooledUnsafeDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n, int n2) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n, n2);
        }

        @Override
        protected final ByteBuffer allocateDirect(int n) {
            ByteBuffer byteBuffer = super.allocateDirect(n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect(n);
        }
    }

    private static final class InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf
    extends UnpooledUnsafeNoCleanerDirectByteBuf {
        InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n, int n2) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n, n2);
        }

        @Override
        protected final ByteBuffer allocateDirect(int n) {
            ByteBuffer byteBuffer = super.allocateDirect(n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        @Override
        final ByteBuffer reallocateDirect(ByteBuffer byteBuffer, int n) {
            int n2 = byteBuffer.capacity();
            byteBuffer = super.reallocateDirect(byteBuffer, n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementDirect(byteBuffer.capacity() - n2);
            return byteBuffer;
        }

        @Override
        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementDirect(n);
        }
    }

    private static final class InstrumentedUnpooledHeapByteBuf
    extends UnpooledHeapByteBuf {
        InstrumentedUnpooledHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n, int n2) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n, n2);
        }

        @Override
        protected final byte[] allocateArray(int n) {
            byte[] byArray = super.allocateArray(n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        @Override
        protected final void freeArray(byte[] byArray) {
            int n = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementHeap(n);
        }
    }

    private static final class InstrumentedUnpooledUnsafeHeapByteBuf
    extends UnpooledUnsafeHeapByteBuf {
        InstrumentedUnpooledUnsafeHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n, int n2) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n, n2);
        }

        @Override
        protected final byte[] allocateArray(int n) {
            byte[] byArray = super.allocateArray(n);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        @Override
        protected final void freeArray(byte[] byArray) {
            int n = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)((ByteBuf)this).alloc()).decrementHeap(n);
        }
    }
}

