/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedArrayType;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

public final class UnsignedTypes {
    public static final UnsignedTypes INSTANCE;
    private static final Set<Name> unsignedTypeNames;
    private static final Set<Name> unsignedArrayTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final HashMap<UnsignedArrayType, Name> unsignedArrayTypeToArrayCall;
    private static final Set<Name> arrayClassesShortNames;

    private UnsignedTypes() {
    }

    public final boolean isShortNameOfUnsignedArray(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return arrayClassesShortNames.contains(name);
    }

    public final ClassId getUnsignedClassIdByArrayClassId(ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        return arrayClassIdToUnsignedClassId.get(classId);
    }

    @JvmStatic
    public static final boolean isUnsignedType(KotlinType annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"");
        if (TypeUtils.noExpectedType(annotated)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = annotated.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        annotated = classifierDescriptor;
        return INSTANCE.isUnsignedClass((DeclarationDescriptor)annotated);
    }

    public final boolean isUnsignedClass(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        return declarationDescriptor2 instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)declarationDescriptor2).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(declarationDescriptor.getName());
    }

    static {
        Collection collection;
        int n;
        INSTANCE = new UnsignedTypes();
        UnsignedType[] object2 = UnsignedType.values();
        Enum[] enumArray = object2;
        Collection collection2 = new ArrayList(object2.length);
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            UnsignedType unsignedType;
            UnsignedType unsignedType2 = unsignedType = enumArray[n];
            collection = collection2;
            collection.add(unsignedType2.getTypeName());
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)collection2));
        UnsignedArrayType[] unsignedArrayTypeArray = UnsignedArrayType.values();
        enumArray = unsignedArrayTypeArray;
        collection2 = new ArrayList(unsignedArrayTypeArray.length);
        n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            Enum enum_;
            Enum enum_2 = enum_ = enumArray[n];
            collection = collection2;
            collection.add(((UnsignedArrayType)enum_2).getTypeName());
        }
        unsignedArrayTypeNames = CollectionsKt.toSet((Iterable)((List)collection2));
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)((Object)UnsignedArrayType.UBYTEARRAY), (Object)Name.identifier("ubyteArrayOf"));
        pairArray2[1] = TuplesKt.to((Object)((Object)UnsignedArrayType.USHORTARRAY), (Object)Name.identifier("ushortArrayOf"));
        pairArray2[2] = TuplesKt.to((Object)((Object)UnsignedArrayType.UINTARRAY), (Object)Name.identifier("uintArrayOf"));
        pairArray2[3] = TuplesKt.to((Object)((Object)UnsignedArrayType.ULONGARRAY), (Object)Name.identifier("ulongArrayOf"));
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf((Pair[])pairArray2);
        UnsignedType[] unsignedTypeArray = UnsignedType.values();
        Collection collection3 = new LinkedHashSet();
        int n3 = unsignedTypeArray.length;
        for (int i = 0; i < n3; ++i) {
            UnsignedType unsignedType;
            UnsignedType unsignedType3 = unsignedType = unsignedTypeArray[i];
            collection = collection3;
            collection.add(unsignedType3.getArrayClassId().getShortClassName());
        }
        arrayClassesShortNames = (Set)collection3;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            ((Map)arrayClassIdToUnsignedClassId).put(unsignedType.getArrayClassId(), unsignedType.getClassId());
            ((Map)unsignedClassIdToArrayClassId).put(unsignedType.getClassId(), unsignedType.getArrayClassId());
        }
    }
}

