/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    public RuleBasedIpFilter(IpFilterRule ... ipFilterRuleArray) {
        this(true, ipFilterRuleArray);
    }

    public RuleBasedIpFilter(boolean bl, IpFilterRule ... ipFilterRuleArray) {
        ObjectUtil.checkNotNull((Object)ipFilterRuleArray, (String)"rules");
        this.acceptIfNotFound = bl;
        this.rules = new ArrayList<IpFilterRule>(ipFilterRuleArray.length);
        IpFilterRule[] ipFilterRuleArray2 = ipFilterRuleArray;
        int n = ipFilterRuleArray.length;
        for (int i = 0; i < n; ++i) {
            IpFilterRule ipFilterRule = ipFilterRuleArray2[i];
            if (ipFilterRule == null) continue;
            this.rules.add(ipFilterRule);
        }
    }

    @Override
    protected boolean accept(ChannelHandlerContext object, InetSocketAddress inetSocketAddress) {
        for (IpFilterRule ipFilterRule : this.rules) {
            if (!ipFilterRule.matches(inetSocketAddress)) continue;
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

