/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

final class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final OpenSslKeyMaterialProvider provider;

    OpenSslKeyMaterialManager(OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
        this.provider = openSslKeyMaterialProvider;
    }

    final void setKeyMaterialServerSide(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        Object[] objectArray = referenceCountedOpenSslEngine.authMethods();
        if (objectArray.length == 0) {
            throw new SSLHandshakeException("Unable to find key material");
        }
        HashSet<String> hashSet = new HashSet<String>(KEY_TYPES.size());
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray2[i];
            if ((string = KEY_TYPES.get(string)) == null || !hashSet.add(string) || (string = this.chooseServerAlias(referenceCountedOpenSslEngine, string)) == null) continue;
            this.setKeyMaterial(referenceCountedOpenSslEngine, string);
            return;
        }
        throw new SSLHandshakeException("Unable to find key material for auth method(s): " + Arrays.toString(objectArray));
    }

    final void setKeyMaterialClientSide(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String[] object, X500Principal[] x500PrincipalArray) {
        if ((object = this.chooseClientAlias(referenceCountedOpenSslEngine, (String[])object, x500PrincipalArray)) != null) {
            this.setKeyMaterial(referenceCountedOpenSslEngine, (String)object);
        }
    }

    private void setKeyMaterial(ReferenceCountedOpenSslEngine object, String string) {
        block9: {
            OpenSslKeyMaterial openSslKeyMaterial = null;
            try {
                openSslKeyMaterial = this.provider.chooseKeyMaterial(((ReferenceCountedOpenSslEngine)object).alloc, string);
                if (openSslKeyMaterial == null) {
                    return;
                }
                ((ReferenceCountedOpenSslEngine)object).setKeyMaterial(openSslKeyMaterial);
                if (openSslKeyMaterial == null) break block9;
                openSslKeyMaterial.release();
            }
            catch (SSLException sSLException) {
                object = sSLException;
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException(exception);
            }
            finally {
                if (openSslKeyMaterial != null) {
                    openSslKeyMaterial.release();
                }
            }
            return;
        }
    }

    private String chooseClientAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) {
        X509KeyManager x509KeyManager = this.provider.keyManager();
        if (x509KeyManager instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)x509KeyManager).chooseEngineClientAlias(stringArray, x500PrincipalArray, referenceCountedOpenSslEngine);
        }
        return x509KeyManager.chooseClientAlias(stringArray, x500PrincipalArray, null);
    }

    private String chooseServerAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        X509KeyManager x509KeyManager = this.provider.keyManager();
        if (x509KeyManager instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)x509KeyManager).chooseEngineServerAlias(string, null, referenceCountedOpenSslEngine);
        }
        return x509KeyManager.chooseServerAlias(string, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

