/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.AsyncRunnable;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.ExtendedOpenSslSession;
import io.netty.handler.ssl.Java7SslParametersUtils;
import io.netty.handler.ssl.Java8SslUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslInternalSession;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SignatureAlgorithmConverter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.LazyJavaxX509Certificate;
import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.internal.tcnative.AsyncTask;
import io.netty.internal.tcnative.Buffer;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.security.cert.X509Certificate;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV2 = 0;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV3 = 1;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1 = 2;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_1 = 3;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_2 = 4;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_3 = 5;
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private HandshakeState handshakeState = HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private boolean hasTLSv13Cipher;
    private boolean sessionSet;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                ReferenceCountedOpenSslEngine.this.leak.record(object);
            }
            return ReferenceCountedOpenSslEngine.this;
        }

        protected void deallocate() {
            ReferenceCountedOpenSslEngine.this.shutdown();
            if (ReferenceCountedOpenSslEngine.this.leak != null) {
                boolean bl = ReferenceCountedOpenSslEngine.this.leak.close((Object)ReferenceCountedOpenSslEngine.this);
                assert (bl);
            }
            ReferenceCountedOpenSslEngine.this.parentContext.release();
        }
    };
    private final Set<String> enabledProtocols = new LinkedHashSet<String>();
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private String endpointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslContext parentContext;
    private final OpenSslInternalSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable pendingException;
    private static final X509Certificate[] JAVAX_CERTS_NOT_SUPPORTED = new X509Certificate[0];

    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator object, String string, int n, boolean bl, boolean bl2, String string2) {
        super(string, n);
        long l;
        OpenSsl.ensureAvailability();
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        this.jdkCompatibilityMode = bl;
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)object, (String)"alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)((SslContext)referenceCountedOpenSslContext).applicationProtocolNegotiator();
        this.clientMode = ((SslContext)referenceCountedOpenSslContext).isClient();
        this.endpointIdentificationAlgorithm = string2;
        this.session = PlatformDependent.javaVersion() >= 7 ? new ExtendedOpenSslSession(new DefaultOpenSslSession(referenceCountedOpenSslContext.sessionContext())){
            private String[] peerSupportedSignatureAlgorithms;
            private List requestedServerNames;

            @Override
            public List getRequestedServerNames() {
                if (ReferenceCountedOpenSslEngine.this.clientMode) {
                    return Java8SslUtils.getSniHostNames(ReferenceCountedOpenSslEngine.this.sniHostNames);
                }
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.requestedServerNames == null) {
                        String string;
                        this.requestedServerNames = ReferenceCountedOpenSslEngine.this.isDestroyed() ? Collections.emptyList() : ((string = SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl)) == null ? Collections.emptyList() : Java8SslUtils.getSniHostName(SSL.getSniHostname((long)ReferenceCountedOpenSslEngine.this.ssl).getBytes(CharsetUtil.UTF_8)));
                    }
                    return this.requestedServerNames;
                }
            }

            @Override
            public String[] getPeerSupportedSignatureAlgorithms() {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.peerSupportedSignatureAlgorithms == null) {
                        if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                            this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                        } else {
                            String[] stringArray = SSL.getSigAlgs((long)ReferenceCountedOpenSslEngine.this.ssl);
                            if (stringArray == null) {
                                this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                            } else {
                                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
                                for (String string : stringArray) {
                                    if ((string = SignatureAlgorithmConverter.toJavaName(string)) == null) continue;
                                    linkedHashSet.add(string);
                                }
                                this.peerSupportedSignatureAlgorithms = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
                            }
                        }
                    }
                    return (String[])this.peerSupportedSignatureAlgorithms.clone();
                }
            }

            @Override
            public List<byte[]> getStatusResponses() {
                byte[] byArray = null;
                if (ReferenceCountedOpenSslEngine.this.enableOcsp && ReferenceCountedOpenSslEngine.this.clientMode) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                    synchronized (referenceCountedOpenSslEngine) {
                        if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                            byArray = SSL.getOcspResponse((long)ReferenceCountedOpenSslEngine.this.ssl);
                        }
                    }
                }
                if (byArray == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(byArray);
            }
        } : new DefaultOpenSslSession(referenceCountedOpenSslContext.sessionContext());
        if (!referenceCountedOpenSslContext.sessionContext().useKeyManager()) {
            this.session.setLocalCertificate(referenceCountedOpenSslContext.keyCertChain);
        }
        object = referenceCountedOpenSslContext.ctxLock.readLock();
        object.lock();
        try {
            l = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!((SslContext)referenceCountedOpenSslContext).isClient() ? 1 : 0) != 0);
        }
        finally {
            object.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = l;
            try {
                boolean bl3;
                this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
                referenceCountedOpenSslEngine2.setClientAuth(referenceCountedOpenSslEngine2.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                assert (referenceCountedOpenSslContext.protocols != null);
                this.hasTLSv13Cipher = referenceCountedOpenSslContext.hasTLSv13Cipher;
                this.setEnabledProtocols(referenceCountedOpenSslContext.protocols);
                if (this.clientMode && SslUtils.isValidHostNameForSNI(string) && (PlatformDependent.javaVersion() < 8 || Java8SslUtils.isValidHostNameForSNI(string))) {
                    SSL.setTlsExtHostName((long)this.ssl, (String)string);
                    this.sniHostNames = Collections.singletonList(string);
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp((long)this.ssl);
                }
                if (!bl) {
                    SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                }
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(SSL.getOptions((long)this.ssl), SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3") && (bl3 = this.clientMode ? ReferenceCountedOpenSslContext.CLIENT_ENABLE_SESSION_TICKET_TLSV13 : ReferenceCountedOpenSslContext.SERVER_ENABLE_SESSION_TICKET_TLSV13)) {
                    SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_NO_TICKET);
                }
                if (OpenSsl.isBoringSSL() && this.clientMode) {
                    SSL.setRenegotiateMode((long)this.ssl, (int)SSL.SSL_RENEGOTIATE_ONCE);
                }
                this.calculateMaxWrapOverhead();
                this.configureEndpointVerification(string2);
            }
            catch (Throwable throwable) {
                this.shutdown();
                PlatformDependent.throwException((Throwable)throwable);
            }
        }
        this.parentContext = referenceCountedOpenSslContext;
        this.parentContext.retain();
        this.leak = bl2 ? leakDetector.track((Object)this) : null;
    }

    final synchronized String[] authMethods() {
        if (this.isDestroyed()) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        return SSL.authenticationMethods((long)this.ssl);
    }

    final boolean setKeyMaterial(OpenSslKeyMaterial openSslKeyMaterial) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return false;
            }
            SSL.setKeyMaterial((long)this.ssl, (long)openSslKeyMaterial.certificateChainAddress(), (long)openSslKeyMaterial.privateKeyAddress());
        }
        this.session.setLocalCertificate(openSslKeyMaterial.certificateChain());
        return true;
    }

    final synchronized SecretKeySpec masterKey() {
        if (this.isDestroyed()) {
            return null;
        }
        return new SecretKeySpec(SSL.getMasterKey((long)this.ssl), "AES");
    }

    synchronized boolean isSessionReused() {
        if (this.isDestroyed()) {
            return false;
        }
        return SSL.isSessionReused((long)this.ssl);
    }

    public void setOcspResponse(byte[] byArray) {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (this.clientMode) {
            throw new IllegalStateException("Not a server SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                SSL.setOcspResponse((long)this.ssl, (byte[])byArray);
            }
            return;
        }
    }

    public byte[] getOcspResponse() {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (!this.clientMode) {
            throw new IllegalStateException("Not a client SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return SSL.getOcspResponse((long)this.ssl);
        }
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    public final ReferenceCounted retain(int n) {
        this.refCnt.retain(n);
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    public final boolean release(int n) {
        return this.refCnt.release(n);
    }

    @Override
    public String getApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.engineMap != null) {
                this.engineMap.remove(this.ssl);
            }
            SSL.freeSSL((long)this.ssl);
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            referenceCountedOpenSslEngine.networkBIO = 0L;
            referenceCountedOpenSslEngine.ssl = 0L;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
            referenceCountedOpenSslEngine2.outboundClosed = true;
            referenceCountedOpenSslEngine2.isInboundDone = true;
        }
        SSL.clearError();
    }

    private int writePlaintextData(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n2), (int)n);
            if (n > 0) {
                byteBuffer.position(n2 + n);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                byteBuffer.limit(n2 + n);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n3);
                n = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n);
                if (n > 0) {
                    byteBuffer.position(n2 + n);
                } else {
                    byteBuffer.position(n2);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    synchronized void bioSetFd(int n) {
        if (!this.isDestroyed()) {
            SSL.bioSetFd((long)this.ssl, (int)n);
        }
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n2), (int)n, (boolean)false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                int n3 = byteBuffer.limit();
                byteBuffer.limit(n2 + n);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n2);
                byteBuffer.limit(n3);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)n, (boolean)false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException((Throwable)throwable);
            }
        }
        return null;
    }

    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n2), (int)(byteBuffer.limit() - n2));
            if (n > 0) {
                byteBuffer.position(n2 + n);
            }
        } else {
            int n3 = byteBuffer.limit();
            n = Math.min(this.maxEncryptedPacketLength0(), n3 - n2);
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                n = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n);
                if (n > 0) {
                    byteBuffer.limit(n2 + n);
                    ByteBuf byteBuf2 = byteBuf;
                    byteBuf2.getBytes(byteBuf2.readerIndex(), byteBuffer);
                    byteBuffer.limit(n3);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    final synchronized int maxWrapOverhead() {
        return this.maxWrapOverhead;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n, int n2) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n + (long)this.maxWrapOverhead * (long)n2);
    }

    final int calculateOutNetBufSize(int n, int n2) {
        return (int)Math.min(Integer.MAX_VALUE, (long)n + (long)this.maxWrapOverhead * (long)n2);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        if (this.handshakeState != HandshakeState.FINISHED) {
            return 0;
        }
        return SSL.sslPending((long)this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n, int n2, int n3) {
        return (long)n - (long)this.maxWrapOverhead * (long)n3 >= (long)n2;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] var1_1, int var2_11, int var3_12, ByteBuffer var4_19) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[TRYBLOCK]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n, n2);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n, n2);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult(status, handshakeStatus, n, n2);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        return referenceCountedOpenSslEngine.newResult(referenceCountedOpenSslEngine.mayFinishHandshake(handshakeStatus, n, n2), n, n2);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus, n, n2), n, n2);
    }

    private SSLException shutdownWithError(String string, int n, int n2) {
        Object object;
        if (logger.isDebugEnabled()) {
            object = SSL.getErrorString((long)n2);
            logger.debug("{} failed with {}: OpenSSL error: {} {}", new Object[]{string, n, n2, object});
        }
        this.shutdown();
        object = this.newSSLExceptionForError(n2);
        if (this.pendingException != null) {
            ((Throwable)object).initCause(this.pendingException);
            this.pendingException = null;
        }
        return object;
    }

    private SSLEngineResult handleUnwrapException(int n, int n2, SSLException sSLException) {
        int n3 = SSL.getLastErrorNumber();
        if (n3 != 0) {
            return this.sslReadErrorResult(SSL.SSL_ERROR_SSL, n3, n, n2);
        }
        throw sSLException;
    }

    /*
     * Exception decompiling
     */
    public final SSLEngineResult unwrap(ByteBuffer[] var1_1, int var2_5, int var3_6, ByteBuffer[] var4_8, int var5_9, int var6_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean needWrapAgain(int n) {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            if (this.pendingException == null) {
                this.pendingException = this.newSSLExceptionForError(n);
            } else if (ReferenceCountedOpenSslEngine.shouldAddSuppressed(this.pendingException, n)) {
                ThrowableUtil.addSuppressed((Throwable)this.pendingException, (Throwable)this.newSSLExceptionForError(n));
            }
            SSL.clearError();
            return true;
        }
        return false;
    }

    private SSLException newSSLExceptionForError(int n) {
        String string = SSL.getErrorString((long)n);
        if (this.handshakeState == HandshakeState.FINISHED) {
            return new OpenSslException(string, n);
        }
        return new OpenSslHandshakeException(string, n);
    }

    private static boolean shouldAddSuppressed(Throwable throwableArray, int n) {
        for (Throwable throwable : ThrowableUtil.getSuppressed((Throwable)throwableArray)) {
            if (!(throwable instanceof NativeSslException) || ((NativeSslException)((Object)throwable)).errorCode() != n) continue;
            return false;
        }
        return true;
    }

    private SSLEngineResult sslReadErrorResult(int n, int n2, int n3, int n4) {
        if (this.needWrapAgain(n2)) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
        }
        throw this.shutdownWithError("SSL_read", n, n2);
    }

    private void closeAll() {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() {
        if (!this.isDestroyed() && (!this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 1 || this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 2) && !"TLSv1.3".equals(this.session.getProtocol()) && this.handshakeState == HandshakeState.FINISHED) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray, int n, int n2) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), 0, 1, byteBufferArray, n, n2);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer object, ByteBuffer byteBuffer) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.wrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBuffer);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer byteBuffer) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), this.singleDstBuffer(byteBuffer));
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBufferArray);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    private void runAndResetNeedTask(Runnable runnable) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            try {
                if (this.isDestroyed()) {
                    return;
                }
                runnable.run();
                if (this.handshakeState != HandshakeState.FINISHED && !this.isDestroyed() && SSL.doHandshake((long)this.ssl) <= 0) {
                    SSL.clearError();
                }
            }
            finally {
                this.needTask = false;
            }
            return;
        }
    }

    @Override
    public final synchronized Runnable getDelegatedTask() {
        if (this.isDestroyed()) {
            return null;
        }
        Runnable runnable = SSL.getTask((long)this.ssl);
        if (runnable == null) {
            return null;
        }
        if (runnable instanceof AsyncTask) {
            return new AsyncTaskDecorator((AsyncTask)runnable);
        }
        return new TaskDecorator(this, runnable);
    }

    @Override
    public final synchronized void closeInbound() {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n = SSL.getShutdown((long)this.ssl);
            if ((n & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
            return;
        }
        this.shutdown();
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int n = SSL.shutdownSSL((long)this.ssl);
        if (n < 0) {
            if ((n = SSL.getError((long)this.ssl, (int)n)) == SSL.SSL_ERROR_SYSCALL || n == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    n = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)n, (Object)SSL.getErrorString((long)n));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public final String[] getEnabledCipherSuites() {
        boolean bl;
        String[] stringArray;
        String[] stringArray2;
        Object object = this;
        synchronized (object) {
            if (!this.isDestroyed()) {
                stringArray2 = SSL.getCiphers((long)this.ssl);
                int n = SSL.getOptions((long)this.ssl);
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                    stringArray = OpenSsl.EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
                    bl = true;
                } else {
                    stringArray = EmptyArrays.EMPTY_STRINGS;
                    bl = false;
                }
            } else {
                return EmptyArrays.EMPTY_STRINGS;
            }
        }
        if (stringArray2 == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        object = new LinkedHashSet(stringArray2.length + stringArray.length);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = this.toJavaCipherSuite(stringArray2[i]);
                String string2 = string = string == null ? stringArray2[i] : string;
                if ((!bl || !OpenSsl.isTlsv13Supported()) && SslUtils.isTLSv13Cipher(string)) continue;
                object.add(string);
            }
            Collections.addAll(object, stringArray);
        }
        return object.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public final void setEnabledCipherSuites(String[] object) {
        ObjectUtil.checkNotNull((Object)object, (String)"cipherSuites");
        CharSequence charSequence = new StringBuilder();
        Object object2 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(object), (StringBuilder)charSequence, (StringBuilder)object2, OpenSsl.isBoringSSL());
        object = ((StringBuilder)charSequence).toString();
        charSequence = ((StringBuilder)object2).toString();
        if (!OpenSsl.isTlsv13Supported() && !((String)charSequence).isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        object2 = this;
        synchronized (object2) {
            boolean bl = this.hasTLSv13Cipher = !((String)charSequence).isEmpty();
            if (!this.isDestroyed()) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)object, (boolean)false);
                    if (OpenSsl.isTlsv13Supported()) {
                        SSL.setCipherSuites((long)this.ssl, (String)OpenSsl.checkTls13Ciphers(logger, (String)charSequence), (boolean)true);
                    }
                    HashSet<String> hashSet = new HashSet<String>(this.enabledProtocols);
                    if (((String)object).isEmpty()) {
                        hashSet.remove("TLSv1");
                        hashSet.remove("TLSv1.1");
                        hashSet.remove("TLSv1.2");
                        hashSet.remove("SSLv3");
                        hashSet.remove("SSLv2");
                        hashSet.remove("SSLv2Hello");
                    }
                    if (((String)charSequence).isEmpty()) {
                        hashSet.remove("TLSv1.3");
                    }
                    this.setEnabledProtocols0(hashSet.toArray(EmptyArrays.EMPTY_STRINGS), !this.hasTLSv13Cipher);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + (String)object, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + (String)object);
            }
            return;
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public final String[] getEnabledProtocols() {
        return this.enabledProtocols.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    private static boolean isProtocolEnabled(int n, int n2, String string) {
        return (n & n2) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string);
    }

    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        ObjectUtil.checkNotNullWithIAE((Object)stringArray, (String)"protocols");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.enabledProtocols.clear();
            this.enabledProtocols.add("SSLv2Hello");
            Collections.addAll(this.enabledProtocols, stringArray);
            this.setEnabledProtocols0(stringArray, !this.hasTLSv13Cipher);
            return;
        }
    }

    private void setEnabledProtocols0(String[] stringArray, boolean bl) {
        assert (Thread.holdsLock(this));
        int n = OPENSSL_OP_NO_PROTOCOLS.length;
        int n2 = 0;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray2[i];
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                if (n > 0) {
                    n = 0;
                }
                if (n2 >= 0) continue;
                n2 = 0;
                continue;
            }
            if (string.equals("SSLv3")) {
                if (n > 1) {
                    n = 1;
                }
                if (n2 > 0) continue;
                n2 = 1;
                continue;
            }
            if (string.equals("TLSv1")) {
                if (n > 2) {
                    n = 2;
                }
                if (n2 >= 2) continue;
                n2 = 2;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                if (n > 3) {
                    n = 3;
                }
                if (n2 >= 3) continue;
                n2 = 3;
                continue;
            }
            if (string.equals("TLSv1.2")) {
                if (n > 4) {
                    n = 4;
                }
                if (n2 >= 4) continue;
                n2 = 4;
                continue;
            }
            if (bl || !string.equals("TLSv1.3")) continue;
            if (n > 5) {
                n = 5;
            }
            if (n2 >= 5) continue;
            n2 = 5;
        }
        if (!this.isDestroyed()) {
            SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3));
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                n4 |= OPENSSL_OP_NO_PROTOCOLS[n3];
            }
            assert (n2 != Integer.MAX_VALUE);
            for (n3 = n2 + 1; n3 < OPENSSL_OP_NO_PROTOCOLS.length; ++n3) {
                n4 |= OPENSSL_OP_NO_PROTOCOLS[n3];
            }
            SSL.setOptions((long)this.ssl, (int)n4);
            return;
        }
        throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                return;
            }
            case STARTED_EXPLICITLY: {
                return;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                return;
            }
        }
        throw new Error();
    }

    private void checkEngineClosed() {
        if (this.isDestroyed()) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n) {
        if (n > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshakeException() {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable throwable = this.pendingException;
        assert (throwable != null);
        this.pendingException = null;
        this.shutdown();
        if (throwable instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)throwable;
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
        sSLHandshakeException.initCause(throwable);
        throw sSLHandshakeException;
    }

    final void initHandshakeException(Throwable throwable) {
        if (this.pendingException == null) {
            this.pendingException = throwable;
            return;
        }
        ThrowableUtil.addSuppressed((Throwable)this.pendingException, (Throwable)throwable);
    }

    private SSLEngineResult.HandshakeStatus handshake() {
        int n;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.pendingException != null) {
            if (SSL.doHandshake((long)this.ssl) <= 0) {
                SSL.clearError();
            }
            return this.handshakeException();
        }
        this.engineMap.add(this);
        if (!this.sessionSet) {
            if (!this.parentContext.sessionContext().setSessionFromCache(this.ssl, this.session, this.getPeerHost(), this.getPeerPort())) {
                this.session.prepareHandshake();
            }
            this.sessionSet = true;
        }
        if ((n = SSL.doHandshake((long)this.ssl)) <= 0) {
            if ((n = SSL.getError((long)this.ssl, (int)n)) == SSL.SSL_ERROR_WANT_READ || n == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            if (n == SSL.SSL_ERROR_WANT_X509_LOOKUP || n == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            int n2 = SSL.getLastErrorNumber();
            if (this.needWrapAgain(n2)) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.pendingException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", n, n2);
        }
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished(SSL.getSessionId((long)this.ssl), SSL.getCipherForSSL((long)this.ssl), SSL.getVersion((long)this.ssl), SSL.getPeerCertificate((long)this.ssl), SSL.getPeerCertChain((long)this.ssl), SSL.getTime((long)this.ssl) * 1000L, this.parentContext.sessionTimeout() * 1000L);
        this.selectApplicationProtocol();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && n2 > 0 || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n > 0) {
            return this.handshake();
        }
        return this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED);
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.handshakeState != HandshakeState.FINISHED) {
                return this.handshake();
            }
            if (!this.isDestroyed() && SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n) {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(n);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SSL.getVersion((long)this.ssl);
        string2 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string2);
        return CipherSuiteConverter.toJava(string, string2);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    public final synchronized void setVerify(int n, int n2) {
        if (!this.isDestroyed()) {
            SSL.setVerify((long)this.ssl, (int)n, (int)n2);
        }
    }

    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            if (!this.isDestroyed()) {
                switch (clientAuth) {
                    case NONE: {
                        SSL.setVerify((long)this.ssl, (int)0, (int)10);
                        break;
                    }
                    case REQUIRE: {
                        SSL.setVerify((long)this.ssl, (int)2, (int)10);
                        break;
                    }
                    case OPTIONAL: {
                        SSL.setVerify((long)this.ssl, (int)1, (int)10);
                        break;
                    }
                    default: {
                        throw new Error(clientAuth.toString());
                    }
                }
            }
            this.clientAuth = clientAuth;
            return;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(sSLParameters, this.endpointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sSLParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sSLParameters, (SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sSLParameters, this.matchers);
            }
        }
        return sSLParameters;
    }

    @Override
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            if (sSLParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            boolean bl = this.isDestroyed();
            if (n >= 8) {
                if (!bl) {
                    if (this.clientMode) {
                        List<String> list = Java8SslUtils.getSniHostNames(sSLParameters);
                        for (String string : list) {
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                        }
                        this.sniHostNames = list;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sSLParameters)) {
                        SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sSLParameters.getSNIMatchers();
            }
            String string = sSLParameters.getEndpointIdentificationAlgorithm();
            if (!bl) {
                this.configureEndpointVerification(string);
            }
            this.endpointIdentificationAlgorithm = string;
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters(sSLParameters);
    }

    private void configureEndpointVerification(String string) {
        if (this.clientMode && ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled(string)) {
            SSL.setVerify((long)this.ssl, (int)2, (int)-1);
        }
    }

    private static boolean isEndPointVerificationEnabled(String string) {
        return string != null && !string.isEmpty();
    }

    private boolean isDestroyed() {
        return this.destroyed;
    }

    final boolean checkSniHostnameMatch(byte[] byArray) {
        return Java8SslUtils.checkSniHostnameMatch(this.matchers, byArray);
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    private void selectApplicationProtocol() {
        ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior = this.apn.selectedListenerFailureBehavior();
        List<String> list = this.apn.protocols();
        switch (this.apn.protocol()) {
            case NONE: {
                return;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                return;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                return;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) {
                    string = SSL.getNextProtoNegotiated((long)this.ssl);
                }
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                return;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior, String string) {
        if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n = list.size();
        assert (n > 0);
        if (list.contains(string)) {
            return string;
        }
        if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    private static final class OpenSslHandshakeException
    extends SSLHandshakeException
    implements NativeSslException {
        private final int errorCode;

        OpenSslHandshakeException(String string, int n) {
            super(string);
            this.errorCode = n;
        }

        @Override
        public final int errorCode() {
            return this.errorCode;
        }
    }

    private static final class OpenSslException
    extends SSLException
    implements NativeSslException {
        private final int errorCode;

        OpenSslException(String string, int n) {
            super(string);
            this.errorCode = n;
        }

        @Override
        public final int errorCode() {
            return this.errorCode;
        }
    }

    private static interface NativeSslException {
        public int errorCode();
    }

    private final class DefaultOpenSslSession
    implements OpenSslInternalSession {
        private final OpenSslSessionContext sessionContext;
        private X509Certificate[] x509PeerCerts;
        private Certificate[] peerCerts;
        private boolean valid = true;
        private String protocol;
        private String cipher;
        private OpenSslSessionId id = OpenSslSessionId.NULL_ID;
        private long creationTime;
        private long lastAccessed = -1L;
        private volatile int applicationBufferSize = MAX_PLAINTEXT_LENGTH;
        private volatile Certificate[] localCertificateChain;
        private volatile Map<String, Object> keyValueStorage = new ConcurrentHashMap<String, Object>();

        DefaultOpenSslSession(OpenSslSessionContext openSslSessionContext) {
            this.sessionContext = openSslSessionContext;
        }

        private SSLSessionBindingEvent newSSLSessionBindingEvent(String string) {
            return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.this.session, string);
        }

        @Override
        public final void prepareHandshake() {
            this.keyValueStorage.clear();
        }

        @Override
        public final void setSessionDetails(long l, long l2, OpenSslSessionId openSslSessionId, Map<String, Object> map) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.id == OpenSslSessionId.NULL_ID) {
                    this.id = openSslSessionId;
                    this.creationTime = l;
                    this.lastAccessed = l2;
                    this.keyValueStorage = map;
                }
                return;
            }
        }

        @Override
        public final Map<String, Object> keyValueStorage() {
            return this.keyValueStorage;
        }

        @Override
        public final OpenSslSessionId sessionId() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                byte[] byArray;
                if (this.id == OpenSslSessionId.NULL_ID && !ReferenceCountedOpenSslEngine.this.isDestroyed() && (byArray = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.this.ssl)) != null) {
                    this.id = new OpenSslSessionId(byArray);
                }
                return this.id;
            }
        }

        @Override
        public final void setLocalCertificate(Certificate[] certificateArray) {
            this.localCertificateChain = certificateArray;
        }

        @Override
        public final byte[] getId() {
            return this.sessionId().cloneBytes();
        }

        @Override
        public final OpenSslSessionContext getSessionContext() {
            return this.sessionContext;
        }

        @Override
        public final long getCreationTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.creationTime;
            }
        }

        @Override
        public final void setLastAccessedTime(long l) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                this.lastAccessed = l;
                return;
            }
        }

        @Override
        public final long getLastAccessedTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.lastAccessed == -1L ? this.creationTime : this.lastAccessed;
            }
        }

        @Override
        public final void invalidate() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                this.valid = false;
                this.sessionContext.removeFromCache(this.id);
                return;
            }
        }

        @Override
        public final boolean isValid() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.valid || this.sessionContext.isInCache(this.id);
            }
        }

        @Override
        public final void putValue(String string, Object object) {
            ObjectUtil.checkNotNull((Object)string, (String)"name");
            ObjectUtil.checkNotNull((Object)object, (String)"value");
            Object object2 = this.keyValueStorage.put(string, object);
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(this.newSSLSessionBindingEvent(string));
            }
            this.notifyUnbound(object2, string);
        }

        @Override
        public final Object getValue(String string) {
            ObjectUtil.checkNotNull((Object)string, (String)"name");
            return this.keyValueStorage.get(string);
        }

        @Override
        public final void removeValue(String string) {
            ObjectUtil.checkNotNull((Object)string, (String)"name");
            Object object = this.keyValueStorage.remove(string);
            this.notifyUnbound(object, string);
        }

        @Override
        public final String[] getValueNames() {
            return this.keyValueStorage.keySet().toArray(EmptyArrays.EMPTY_STRINGS);
        }

        private void notifyUnbound(Object object, String string) {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(this.newSSLSessionBindingEvent(string));
            }
        }

        @Override
        public final void handshakeFinished(byte[] byArray, String string, String string2, byte[] byArray2, byte[][] byArray3, long l, long l2) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    if (this.id == OpenSslSessionId.NULL_ID) {
                        this.id = byArray == null ? OpenSslSessionId.NULL_ID : new OpenSslSessionId(byArray);
                        DefaultOpenSslSession defaultOpenSslSession = this;
                        defaultOpenSslSession.creationTime = defaultOpenSslSession.lastAccessed = l;
                    }
                    this.cipher = ReferenceCountedOpenSslEngine.this.toJavaCipherSuite(string);
                    this.protocol = string2;
                    if (ReferenceCountedOpenSslEngine.this.clientMode) {
                        if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray3)) {
                            this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES : JAVAX_CERTS_NOT_SUPPORTED;
                        } else {
                            this.peerCerts = new Certificate[byArray3.length];
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[byArray3.length] : JAVAX_CERTS_NOT_SUPPORTED;
                            this.initCerts(byArray3, 0);
                        }
                    } else if (ReferenceCountedOpenSslEngine.isEmpty(byArray2)) {
                        this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                        this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                    } else if (ReferenceCountedOpenSslEngine.isEmpty((Object[])byArray3)) {
                        this.peerCerts = new Certificate[]{new LazyX509Certificate(byArray2)};
                        this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[]{new LazyJavaxX509Certificate(byArray2)} : JAVAX_CERTS_NOT_SUPPORTED;
                    } else {
                        this.peerCerts = new Certificate[byArray3.length + 1];
                        this.peerCerts[0] = new LazyX509Certificate(byArray2);
                        if (OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED) {
                            this.x509PeerCerts = new X509Certificate[byArray3.length + 1];
                            this.x509PeerCerts[0] = new LazyJavaxX509Certificate(byArray2);
                        } else {
                            this.x509PeerCerts = JAVAX_CERTS_NOT_SUPPORTED;
                        }
                        this.initCerts(byArray3, 1);
                    }
                } else {
                    throw new SSLException("Already closed");
                }
                ReferenceCountedOpenSslEngine.this.calculateMaxWrapOverhead();
                ReferenceCountedOpenSslEngine.this.handshakeState = HandshakeState.FINISHED;
                return;
            }
        }

        private void initCerts(byte[][] byArray, int n) {
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = n + i;
                this.peerCerts[n2] = new LazyX509Certificate(byArray[i]);
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) continue;
                this.x509PeerCerts[n2] = new LazyJavaxX509Certificate(byArray[i]);
            }
        }

        @Override
        public final Certificate[] getPeerCertificates() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.isEmpty(this.peerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (Certificate[])this.peerCerts.clone();
            }
        }

        @Override
        public final boolean hasPeerCertificates() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return !ReferenceCountedOpenSslEngine.isEmpty(this.peerCerts);
            }
        }

        @Override
        public final Certificate[] getLocalCertificates() {
            Certificate[] certificateArray = this.localCertificateChain;
            if (this.localCertificateChain == null) {
                return null;
            }
            return (Certificate[])certificateArray.clone();
        }

        @Override
        public final X509Certificate[] getPeerCertificateChain() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) {
                    throw new UnsupportedOperationException();
                }
                if (ReferenceCountedOpenSslEngine.isEmpty(this.x509PeerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (X509Certificate[])this.x509PeerCerts.clone();
            }
        }

        @Override
        public final Principal getPeerPrincipal() {
            Certificate[] certificateArray = this.getPeerCertificates();
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        @Override
        public final Principal getLocalPrincipal() {
            Certificate[] certificateArray = this.localCertificateChain;
            if (this.localCertificateChain == null || certificateArray.length == 0) {
                return null;
            }
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        @Override
        public final String getCipherSuite() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.cipher == null) {
                    return "SSL_NULL_WITH_NULL_NULL";
                }
                return this.cipher;
            }
        }

        @Override
        public final String getProtocol() {
            String string = this.protocol;
            if (string == null) {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    string = !ReferenceCountedOpenSslEngine.this.isDestroyed() ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.this.ssl) : "";
                }
            }
            return string;
        }

        @Override
        public final String getPeerHost() {
            return ReferenceCountedOpenSslEngine.this.getPeerHost();
        }

        @Override
        public final int getPeerPort() {
            return ReferenceCountedOpenSslEngine.this.getPeerPort();
        }

        @Override
        public final int getPacketBufferSize() {
            return SSL.SSL_MAX_ENCRYPTED_LENGTH;
        }

        @Override
        public final int getApplicationBufferSize() {
            return this.applicationBufferSize;
        }

        @Override
        public final void tryExpandApplicationBufferSize(int n) {
            if (n > MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != MAX_RECORD_SIZE) {
                this.applicationBufferSize = MAX_RECORD_SIZE;
            }
        }

        public final String toString() {
            return "DefaultOpenSslSession{sessionContext=" + this.sessionContext + ", id=" + this.id + '}';
        }

        public final int hashCode() {
            return this.sessionId().hashCode();
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OpenSslInternalSession)) {
                return false;
            }
            return this.sessionId().equals(((OpenSslInternalSession)object).sessionId());
        }
    }

    private final class AsyncTaskDecorator
    extends TaskDecorator<AsyncTask>
    implements AsyncRunnable {
        AsyncTaskDecorator(AsyncTask asyncTask) {
            super(ReferenceCountedOpenSslEngine.this, (Runnable)asyncTask);
        }

        @Override
        public final void run(Runnable runnable) {
            if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                return;
            }
            ((AsyncTask)this.task).runAsync((Runnable)new TaskDecorator(ReferenceCountedOpenSslEngine.this, runnable));
        }
    }

    private static class TaskDecorator<R extends Runnable>
    implements Runnable {
        protected final R task;
        final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

        TaskDecorator(R r) {
            this.this$0 = var1_1;
            this.task = r;
        }

        @Override
        public void run() {
            this.this$0.runAndResetNeedTask(this.task);
        }
    }

    private static enum HandshakeState {
        NOT_STARTED,
        STARTED_IMPLICITLY,
        STARTED_EXPLICITLY,
        FINISHED;

    }
}

