/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.NetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;

final class SslUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslUtils.class);
    static final Set<String> TLSV13_CIPHERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256")));
    static final short DTLS_1_0 = -257;
    static final short DTLS_1_2 = -259;
    static final short DTLS_1_3 = -260;
    static final short DTLS_RECORD_HEADER_LENGTH = 13;
    static final int GMSSL_PROTOCOL_VERSION = 257;
    static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    static final int SSL_CONTENT_TYPE_ALERT = 21;
    static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    static final int SSL_CONTENT_TYPE_EXTENSION_HEARTBEAT = 24;
    static final int SSL_RECORD_HEADER_LENGTH = 5;
    static final int NOT_ENOUGH_DATA = -1;
    static final int NOT_ENCRYPTED = -2;
    static final String[] DEFAULT_CIPHER_SUITES;
    static final String[] DEFAULT_TLSV13_CIPHER_SUITES;
    static final String[] TLSV13_CIPHER_SUITES;
    static final String PROBING_CERT = "-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----";
    static final String PROBING_KEY = "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCCBtayYNDrM3NFnkBbwTd6gaWp\na84ENvkWzWgFGtVAe5iZUChqrAPNdgnQs7Brb3cCBYRDWOlxtnaGmhhDOoRkFMucWEyuFEWUfops\nk0PxjfeRn+JJUEEO4Zt1JslKGUz7hbBD0gCyjgxni9bdLWK/l8YakuBu1dGYF/9FTyiY3QaKOW9a\nUtYdaKMs3zFC3JIW4FDuyxbxFwoBqvLelSbpRRAH4KjqWd+2LRPNqDw+COEAmrZnfBuwZGc/ZhK9\nihorqrOYddFiWn8/GuMEBkCaQsmzhhOb9cUX5+R5jHiL3OodvKid7nJ6tGJuwdpdlYudQv6sWh4x\n0q+vRVLewaaFAgMBAAECggEAP8tPJvFtTxhNJAkCloHz0D0vpDHqQBMgntlkgayqmBqLwhyb18pR\ni0qwgh7HHc7wWqOOQuSqlEnrWRrdcI6TSe8R/sErzfTQNoznKWIPYcI/hskk4sdnQ//Yn9/Jvnsv\nU/BBjOTJxtD+sQbhAl80JcA3R+5sArURQkfzzHOL/YMqzAsn5hTzp7HZCxUqBk3KaHRxV7NefeOE\nxlZuWSmxYWfbFIs4kx19/1t7h8CHQWezw+G60G2VBtSBBxDnhBWvqG6R/wpzJ3nEhPLLY9T+XIHe\nipzdMOOOUZorfIg7M+pyYPji+ZIZxIpY5OjrOzXHciAjRtr5Y7l99K1CG1LguQKBgQDrQfIMxxtZ\nvxU/1cRmUV9l7pt5bjV5R6byXq178LxPKVYNjdZ840Q0/OpZEVqaT1xKVi35ohP1QfNjxPLlHD+K\niDAR9z6zkwjIrbwPCnb5kuXy4lpwPcmmmkva25fI7qlpHtbcuQdoBdCfr/KkKaUCMPyY89LCXgEw\n5KTDj64UywKBgQCNfbO+eZLGzhiHhtNJurresCsIGWlInv322gL8CSfBMYl6eNfUTZvUDdFhPISL\nUljKWzXDrjw0ujFSPR0XhUGtiq89H+HUTuPPYv25gVXO+HTgBFZEPl4PpA+BUsSVZy0NddneyqLk\n42Wey9omY9Q8WsdNQS5cbUvy0uG6WFoX7wKBgQDZ1jpW8pa0x2bZsQsm4vo+3G5CRnZlUp+XlWt2\ndDcp5dC0xD1zbs1dc0NcLeGDOTDv9FSl7hok42iHXXq8AygjEm/QcuwwQ1nC2HxmQP5holAiUs4D\nWHM8PWs3wFYPzE459EBoKTxeaeP/uWAn+he8q7d5uWvSZlEcANs/6e77eQKBgD21Ar0hfFfj7mK8\n9E0FeRZBsqK3omkfnhcYgZC11Xa2SgT1yvs2Va2n0RcdM5kncr3eBZav2GYOhhAdwyBM55XuE/sO\neokDVutNeuZ6d5fqV96TRaRBpvgfTvvRwxZ9hvKF4Vz+9wfn/JvCwANaKmegF6ejs7pvmF3whq2k\ndrZVAoGAX5YxQ5XMTD0QbMAl7/6qp6S58xNoVdfCkmkj1ZLKaHKIjS/benkKGlySVQVPexPfnkZx\np/Vv9yyphBoudiTBS9Uog66ueLYZqpgxlM/6OhYg86Gm3U2ycvMxYjBM1NFiyze21AqAhI+HX+Ot\nmraV2/guSgDgZAhukRZzeQ2RucI=\n-----END PRIVATE KEY-----";
    private static final boolean TLSV1_3_JDK_SUPPORTED;
    private static final boolean TLSV1_3_JDK_DEFAULT_ENABLED;

    static boolean isTLSv13SupportedByJDK(Provider provider) {
        if (provider == null) {
            return TLSV1_3_JDK_SUPPORTED;
        }
        return SslUtils.isTLSv13SupportedByJDK0(provider);
    }

    private static boolean isTLSv13SupportedByJDK0(Provider provider) {
        try {
            return SslUtils.arrayContains(SslUtils.newInitContext(provider).getSupportedSSLParameters().getProtocols(), "TLSv1.3");
        }
        catch (Throwable throwable) {
            logger.debug("Unable to detect if JDK SSLEngine with provider {} supports TLSv1.3, assuming no", (Object)provider, (Object)throwable);
            return false;
        }
    }

    static boolean isTLSv13EnabledByJDK(Provider provider) {
        if (provider == null) {
            return TLSV1_3_JDK_DEFAULT_ENABLED;
        }
        return SslUtils.isTLSv13EnabledByJDK0(provider);
    }

    private static boolean isTLSv13EnabledByJDK0(Provider provider) {
        try {
            return SslUtils.arrayContains(SslUtils.newInitContext(provider).getDefaultSSLParameters().getProtocols(), "TLSv1.3");
        }
        catch (Throwable throwable) {
            logger.debug("Unable to detect if JDK SSLEngine with provider {} enables TLSv1.3 by default, assuming no", (Object)provider, (Object)throwable);
            return false;
        }
    }

    private static SSLContext newInitContext(Provider object) {
        object = object == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", (Provider)object);
        ((SSLContext)object).init(null, new TrustManager[0], null);
        return object;
    }

    static SSLContext getSSLContext(String object) {
        object = StringUtil.isNullOrEmpty((String)object) ? SSLContext.getInstance(SslUtils.getTlsVersion()) : SSLContext.getInstance(SslUtils.getTlsVersion(), (String)object);
        ((SSLContext)object).init(null, new TrustManager[0], null);
        return object;
    }

    private static String getTlsVersion() {
        if (TLSV1_3_JDK_SUPPORTED) {
            return "TLSv1.3";
        }
        return "TLSv1.2";
    }

    static boolean arrayContains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static void addIfSupported(Set<String> set, List<String> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            list.add(string);
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, Iterable<String> object) {
        if (list.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.startsWith("SSL_") || string.contains("_RC4_")) continue;
                list.add(string);
            }
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, String ... stringArray) {
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(list, Arrays.asList(stringArray));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    /*
     * Unable to fully structure code
     */
    static int getEncryptedPacketLength(ByteBuf var0, int var1_1, boolean var2_2) {
        block13: {
            block14: {
                if (!SslUtils.$assertionsDisabled && var1_1 < var0.readerIndex()) {
                    throw new AssertionError();
                }
                var3_3 = var0.writerIndex() - var1_1;
                if (var3_3 < 5) {
                    return -1;
                }
                var4_4 = 0;
                switch (var0.getUnsignedByte(var1_1)) {
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        var2_2 = true;
                        break;
                    }
                    default: {
                        if (!var2_2) {
                            return -2;
                        }
                        var2_2 = false;
                    }
                }
                if (!var2_2) break block13;
                var5_5 = var0.getUnsignedByte(var1_1 + 1);
                var6_6 = var0.getShort(var1_1 + 1);
                if (var5_5 != 3 && var6_6 != 257) break block14;
                var4_4 = SslUtils.unsignedShortBE(var0, var1_1 + 3) + 5;
                if (var4_4 > 5) break block13;
                ** GOTO lbl-1000
            }
            if (var6_6 == -257 || var6_6 == -259 || var6_6 == -260) {
                if (var3_3 < 13) {
                    return -1;
                }
                var4_4 = SslUtils.unsignedShortBE(var0, var1_1 + 13 - 2) + 13;
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = false;
            }
        }
        if (!var2_2) {
            var5_5 = (var0.getUnsignedByte(var1_1) & 128) != 0 ? 2 : 3;
            var6_6 = var0.getUnsignedByte(var1_1 + var5_5 + 1);
            if (var6_6 == 2 || var6_6 == 3) {
                var4_4 = var5_5 == 2 ? (SslUtils.shortBE(var0, var1_1) & 32767) + 2 : (SslUtils.shortBE(var0, var1_1) & 16383) + 3;
                if (var4_4 <= var5_5) {
                    return -2;
                }
            } else {
                return -2;
            }
        }
        return var4_4;
    }

    private static int unsignedShortBE(ByteBuf byteBuf, int n) {
        n = byteBuf.getUnsignedShort(n);
        if (byteBuf.order() == ByteOrder.LITTLE_ENDIAN) {
            n = Integer.reverseBytes(n) >>> 16;
        }
        return n;
    }

    private static short shortBE(ByteBuf byteBuf, int n) {
        n = byteBuf.getShort(n);
        if (byteBuf.order() == ByteOrder.LITTLE_ENDIAN) {
            n = Short.reverseBytes((short)n);
        }
        return (short)n;
    }

    private static short unsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    private static int unsignedShortBE(ByteBuffer byteBuffer, int n) {
        return SslUtils.shortBE(byteBuffer, n) & 0xFFFF;
    }

    private static short shortBE(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuffer.getShort(n);
        }
        return ByteBufUtil.swapShort((short)byteBuffer.getShort(n));
    }

    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n) {
        ByteBuffer byteBuffer = byteBufferArray[n];
        if (byteBuffer.remaining() >= 5) {
            return SslUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            if ((byteBuffer = byteBufferArray[n++].duplicate()).remaining() > byteBuffer2.remaining()) {
                ByteBuffer byteBuffer3 = byteBuffer;
                byteBuffer3.limit(byteBuffer3.position() + byteBuffer2.remaining());
            }
            byteBuffer2.put(byteBuffer);
        } while (byteBuffer2.hasRemaining() && n < byteBufferArray.length);
        byteBuffer2.flip();
        return SslUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n;
        boolean bl;
        int n2 = byteBuffer.remaining();
        if (n2 < 5) {
            return -1;
        }
        n2 = 0;
        int n3 = byteBuffer.position();
        switch (SslUtils.unsignedByte(byteBuffer.get(n3))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && ((n = SslUtils.unsignedByte(byteBuffer.get(n3 + 1))) != 3 && byteBuffer.getShort(n3 + 1) != 257 || (n2 = SslUtils.unsignedShortBE(byteBuffer, n3 + 3) + 5) <= 5)) {
            bl = false;
        }
        if (!bl) {
            n = (SslUtils.unsignedByte(byteBuffer.get(n3)) & 0x80) != 0 ? 2 : 3;
            short s = SslUtils.unsignedByte(byteBuffer.get(n3 + n + 1));
            n2 = s;
            if (s == 2 || n2 == 3) {
                n2 = n == 2 ? (SslUtils.shortBE(byteBuffer, n3) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuffer, n3) & 0x3FFF) + 3;
                if (n2 <= n) {
                    return -2;
                }
            } else {
                return -2;
            }
        }
        return n2;
    }

    static void handleHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        channelHandlerContext.flush();
        if (bl) {
            channelHandlerContext.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(throwable));
        }
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator = Base64.encode((ByteBuf)byteBuf2, (int)byteBuf2.readerIndex(), (int)byteBuf.readableBytes(), (boolean)true, (Base64Dialect)Base64Dialect.STANDARD, (ByteBufAllocator)byteBufAllocator);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return byteBufAllocator;
    }

    static boolean isValidHostNameForSNI(String string) {
        return string != null && string.indexOf(46) > 0 && !string.endsWith(".") && !string.startsWith("/") && !NetUtil.isValidIpV4Address((String)string) && !NetUtil.isValidIpV6Address((String)string);
    }

    static boolean isTLSv13Cipher(String string) {
        return TLSV13_CIPHERS.contains(string);
    }

    private SslUtils() {
    }

    static {
        TLSV13_CIPHER_SUITES = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
        TLSV1_3_JDK_SUPPORTED = SslUtils.isTLSv13SupportedByJDK0(null);
        TLSV1_3_JDK_DEFAULT_ENABLED = SslUtils.isTLSv13EnabledByJDK0(null);
        DEFAULT_TLSV13_CIPHER_SUITES = TLSV1_3_JDK_SUPPORTED ? TLSV13_CIPHER_SUITES : EmptyArrays.EMPTY_STRINGS;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        linkedHashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        linkedHashSet.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        linkedHashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        Collections.addAll(linkedHashSet, DEFAULT_TLSV13_CIPHER_SUITES);
        DEFAULT_CIPHER_SUITES = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
    }
}

