/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.gwt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GwtSymbolMapParser {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Map<String, String> symbolMap = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream closeable) {
        if (closeable == null) {
            return;
        }
        closeable = new InputStreamReader((InputStream)closeable, UTF_8);
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            char c;
            while ((c = ((InputStreamReader)closeable).read()) != '\uffffffff') {
                char c2 = c;
                c = c2;
                if (c2 != '\r' && c != '\n') {
                    stringBuilder.append(c);
                    continue;
                }
                this.processLine(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.capacity());
            }
        }
        catch (IOException iOException) {
            try {
                ((InputStreamReader)closeable).close();
                return;
            }
            catch (IOException iOException2) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStreamReader)closeable).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStreamReader)closeable).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public Map<String, String> getSymbolMap() {
        return this.symbolMap;
    }

    public void processLine(String object) {
        if (object.charAt(0) == '#') {
            return;
        }
        if (((String[])(object = object.split(","))).length > 2) {
            String string = object[0];
            String string2 = object[2];
            if ((object = object[3]).isEmpty() && !string.equals(string2)) {
                this.symbolMap.put(string, string2);
            }
            return;
        }
        this.symbolMap.put(object[0], object[1]);
    }
}

