/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.collections.ArrayMap;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import javax.swing.ImageIcon;

public class _OsxAwtTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private volatile CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private volatile Thread keepAliveThread;
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _OsxAwtTray(String object, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        super(runnable);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        this.keepAliveThread = new Thread(() -> {
            CountDownLatch countDownLatch = this.keepAliveLatch;
            synchronized (countDownLatch) {
                this.keepAliveLatch.countDown();
                this.keepAliveLatch = new CountDownLatch(1);
                return;
            }
        }, "TrayKeepAliveThread");
        this.keepAliveThread.start();
        object = new AwtOsxMenu(null){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_OsxAwtTray.this.tray == null) {
                        _OsxAwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean bl = menuItem.getEnabled();
                    if (_OsxAwtTray.this.keepAliveThread != null) {
                        CountDownLatch countDownLatch = _OsxAwtTray.this.keepAliveLatch;
                        synchronized (countDownLatch) {
                            _OsxAwtTray.this.keepAliveLatch.countDown();
                        }
                    }
                    _OsxAwtTray.this.keepAliveThread = null;
                    if (_OsxAwtTray.this.visible && !bl) {
                        _OsxAwtTray.this.tray.remove(_OsxAwtTray.this.trayIcon);
                        _OsxAwtTray.this.visible = false;
                        return;
                    }
                    if (!_OsxAwtTray.this.visible && bl && _OsxAwtTray.this.trayIcon != null) {
                        try {
                            _OsxAwtTray.this.tray.add(_OsxAwtTray.this.trayIcon);
                            _OsxAwtTray.this.visible = true;
                            _OsxAwtTray.this.trayIcon.setToolTip(_OsxAwtTray.this.tooltipText);
                            return;
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)aWTException);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _OsxAwtTray.this.imageFile = menuItem.getImage();
                SwingUtil.INSTANCE.invokeLater(() -> {
                    Object object;
                    if (_OsxAwtTray.this.tray == null) {
                        _OsxAwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_OsxAwtTray.this.imageFile != null) {
                        object = _OsxAwtTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _OsxAwtTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image image = (Image)_OsxAwtTray.this.imageCache.get(object);
                            if (image == null) {
                                image = new ImageIcon((String)object).getImage();
                                _OsxAwtTray.this.imageCache.put(object, (Object)image);
                                if (_OsxAwtTray.this.imageCache.getSize() > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            object = image;
                        }
                    } else {
                        object = null;
                    }
                    if (_OsxAwtTray.this.trayIcon == null) {
                        if (object == null) {
                            return;
                        }
                        _OsxAwtTray.this.trayIcon = new TrayIcon((Image)object);
                        _OsxAwtTray.this.trayIcon.setPopupMenu((PopupMenu)this._native);
                        if (SystemTray.AUTO_FIX_INCONSISTENCIES) {
                            SystemTray.logger.debug("Auto-fixing right-click for macOS system tray");
                            _OsxAwtTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent object) {
                                    if (!((MouseEvent)object).isPopupTrigger() && ((MouseEvent)object).getButton() != 1) {
                                        object = AwtAccessor.getLocation(_OsxAwtTray.this.trayIcon);
                                        object = new Component((Point2D)object){
                                            final /* synthetic */ Point2D val$location;
                                            {
                                                this.val$location = point2D;
                                            }

                                            @Override
                                            public Point getLocationOnScreen() {
                                                return new Point((int)this.val$location.getX() - 4, (int)this.val$location.getY() + 6);
                                            }
                                        };
                                        AwtAccessor.showPopup((Component)object, _native);
                                    }
                                }
                            });
                        }
                        try {
                            _OsxAwtTray.this.tray.add(_OsxAwtTray.this.trayIcon);
                            _OsxAwtTray.this.visible = true;
                        }
                        catch (AWTException aWTException) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)aWTException);
                        }
                    } else {
                        _OsxAwtTray.this.trayIcon.setImage((Image)object);
                    }
                    _OsxAwtTray.this.trayIcon.setToolTip(_OsxAwtTray.this.tooltipText);
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem object) {
                object = ((MenuItem)object).getTooltip();
                if (_OsxAwtTray.this.tooltipText != null && _OsxAwtTray.this.tooltipText.equals(object)) {
                    return;
                }
                _OsxAwtTray.this.tooltipText = (String)object;
                SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setTooltip$2((String)object));
            }

            @Override
            public void remove() {
                Object object = _OsxAwtTray.this.imageCache;
                synchronized (object) {
                    for (Image image : _OsxAwtTray.this.imageCache.getValues()) {
                        image.flush();
                    }
                    _OsxAwtTray.this.imageCache.clear();
                }
                SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
                    if (_OsxAwtTray.this.trayIcon != null) {
                        _OsxAwtTray.this.trayIcon.setPopupMenu(null);
                        if (_OsxAwtTray.this.tray != null) {
                            _OsxAwtTray.this.tray.remove(_OsxAwtTray.this.trayIcon);
                        }
                        _OsxAwtTray.this.trayIcon = null;
                    }
                    _OsxAwtTray.this.tray = null;
                    super.remove();
                });
                if (_OsxAwtTray.this.keepAliveThread != null) {
                    object = _OsxAwtTray.this.keepAliveLatch;
                    synchronized (object) {
                        _OsxAwtTray.this.keepAliveLatch.countDown();
                        return;
                    }
                }
            }

            private /* synthetic */ void lambda$setTooltip$2(String string) {
                if (_OsxAwtTray.this.trayIcon != null) {
                    _OsxAwtTray.this.trayIcon.setToolTip(string);
                }
            }
        };
        this.bind((MenuPeer)object, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

