/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\n\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "<init>", "()V", "cascadeOffset", "Ljava/awt/Point;", "lastFocusedWindows", "", "Ljava/awt/Window;", "focusListener", "androidx/compose/ui/window/WindowLocationTracker$focusListener$1", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "onWindowCreated", "", "window", "onWindowDisposed", "lastActiveGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "getCascadeLocationFor", "ui"})
public final class WindowLocationTracker {
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    private static final Point cascadeOffset = new Point(48, 48);
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        public final void windowGainedFocus(WindowEvent windowEvent) {
            Intrinsics.checkNotNullParameter((Object)windowEvent, (String)"");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(windowEvent.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = windowEvent.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"");
            set.add(window);
        }

        public final void windowLostFocus(WindowEvent windowEvent) {
            Intrinsics.checkNotNullParameter((Object)windowEvent, (String)"");
        }
    };
    public static final int $stable = 8;

    private WindowLocationTracker() {
    }

    public final void onWindowCreated(Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"");
        window.addWindowFocusListener(focusListener);
    }

    public final void onWindowDisposed(Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window);
    }

    public final GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        if (window != null) {
            return window.getGraphicsConfiguration();
        }
        return null;
    }

    public final Point getCascadeLocationFor(Window serializable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)serializable, (String)"");
        Serializable serializable2 = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object2 = serializable2;
        if (serializable2 == null || (object2 = ((Component)object2).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object2 = object = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if (object2 != null) {
            Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
            object = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object);
            Intrinsics.checkNotNull((Object)rectangle);
            Point point = Geometry_desktopKt.plus(Geometry_desktopKt.getLeftTop(rectangle), new Point(((Insets)object).left, ((Insets)object).top));
            object = Geometry_desktopKt.minus(Geometry_desktopKt.getRightBottom(rectangle), new Point(((Insets)object).right, ((Insets)object).bottom));
            Serializable serializable3 = serializable2;
            if (serializable3 == null || (serializable3 = serializable3.getLocation()) == null) {
                serializable3 = point;
            }
            serializable2 = serializable3;
            serializable2 = Geometry_desktopKt.plus((Point)serializable3, cascadeOffset);
            Dimension dimension = serializable.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"");
            serializable = Geometry_desktopKt.plus((Point)serializable2, Geometry_desktopKt.getRightBottom(dimension));
            if (((Point)serializable).x > ((Point)object).x || ((Point)serializable).y > ((Point)object).y) {
                serializable2 = Geometry_desktopKt.plus(point, cascadeOffset);
            }
            return serializable2;
        }
        return cascadeOffset;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

