/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;

class PerFrameDeflateDecoder
extends DeflateDecoder {
    PerFrameDeflateDecoder(boolean bl) {
        super(bl, WebSocketExtensionFilter.NEVER_SKIP);
    }

    PerFrameDeflateDecoder(boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        super(bl, webSocketExtensionFilter);
    }

    public boolean acceptInboundMessage(Object object) {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)((Object)object);
        if (this.extensionDecoderFilter().mustSkip(webSocketFrame)) {
            return false;
        }
        return (object instanceof TextWebSocketFrame || object instanceof BinaryWebSocketFrame || object instanceof ContinuationWebSocketFrame) && (webSocketFrame.rsv() & 4) > 0;
    }

    @Override
    protected int newRsv(WebSocketFrame webSocketFrame) {
        return webSocketFrame.rsv() ^ 4;
    }

    @Override
    protected boolean appendFrameTail(WebSocketFrame webSocketFrame) {
        return true;
    }
}

