/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

public class SpdyFrameEncoder {
    private final int version;

    public SpdyFrameEncoder(SpdyVersion spdyVersion) {
        this.version = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"spdyVersion"))).version();
    }

    protected void writeControlFrameHeader(ByteBuf byteBuf, int n, byte by, int n2) {
        byteBuf.writeShort(this.version | 0x8000);
        byteBuf.writeShort(n);
        byteBuf.writeByte((int)by);
        byteBuf.writeMedium(n2);
    }

    public ByteBuf encodeDataFrame(ByteBufAllocator byteBufAllocator, int n, boolean bl, ByteBuf byteBuf) {
        bl = bl;
        int n2 = byteBuf.readableBytes();
        byteBufAllocator = byteBufAllocator.ioBuffer(n2 + 8).order(ByteOrder.BIG_ENDIAN);
        byteBufAllocator.writeInt(n & Integer.MAX_VALUE);
        byteBufAllocator.writeByte(bl ? 1 : 0);
        byteBufAllocator.writeMedium(n2);
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        return byteBufAllocator;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf encodeSynStreamFrame(ByteBufAllocator byteBufAllocator, int n, int n2, byte by, boolean bl, boolean bl2, ByteBuf byteBuf) {
        byte by2;
        void var6_8;
        int n3;
        void var7_10;
        int n4 = var7_10.readableBytes();
        int n5 = n3 = bl ? 1 : 0;
        if (var6_8 != false) {
            by2 = (byte)(n3 | 2);
        }
        int n6 = n4 + 10;
        byteBufAllocator = byteBufAllocator.ioBuffer(n6 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 1, by2, n6);
        byteBufAllocator.writeInt(n);
        byteBufAllocator.writeInt(n2);
        byteBufAllocator.writeShort((by & 0xFF) << 13);
        void v1 = var7_10;
        byteBufAllocator.writeBytes((ByteBuf)v1, v1.readerIndex(), n4);
        return byteBufAllocator;
    }

    public ByteBuf encodeSynReplyFrame(ByteBufAllocator byteBufAllocator, int n, boolean bl, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        bl = bl;
        int n3 = n2 + 4;
        byteBufAllocator = byteBufAllocator.ioBuffer(n3 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 2, (byte)(bl ? 1 : 0), n3);
        byteBufAllocator.writeInt(n);
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        return byteBufAllocator;
    }

    public ByteBuf encodeRstStreamFrame(ByteBufAllocator byteBufAllocator, int n, int n2) {
        byteBufAllocator = byteBufAllocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 3, (byte)0, 8);
        byteBufAllocator.writeInt(n);
        byteBufAllocator.writeInt(n2);
        return byteBufAllocator;
    }

    public ByteBuf encodeSettingsFrame(ByteBufAllocator byteBufAllocator, SpdySettingsFrame spdySettingsFrame) {
        Object object = spdySettingsFrame.ids();
        int n = object.size();
        byte by = spdySettingsFrame.clearPreviouslyPersistedSettings() ? (byte)1 : 0;
        int n2 = 4 + n * 8;
        byteBufAllocator = byteBufAllocator.ioBuffer(n2 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 4, by, n2);
        byteBufAllocator.writeInt(n);
        object = object.iterator();
        while (object.hasNext()) {
            Integer n3 = (Integer)object.next();
            by = 0;
            if (spdySettingsFrame.isPersistValue(n3)) {
                by = 1;
            }
            if (spdySettingsFrame.isPersisted(n3)) {
                by = (byte)(by | 2);
            }
            byteBufAllocator.writeByte((int)by);
            byteBufAllocator.writeMedium(n3.intValue());
            byteBufAllocator.writeInt(spdySettingsFrame.getValue(n3));
        }
        return byteBufAllocator;
    }

    public ByteBuf encodePingFrame(ByteBufAllocator byteBufAllocator, int n) {
        byteBufAllocator = byteBufAllocator.ioBuffer(12).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 6, (byte)0, 4);
        byteBufAllocator.writeInt(n);
        return byteBufAllocator;
    }

    public ByteBuf encodeGoAwayFrame(ByteBufAllocator byteBufAllocator, int n, int n2) {
        byteBufAllocator = byteBufAllocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 7, (byte)0, 8);
        byteBufAllocator.writeInt(n);
        byteBufAllocator.writeInt(n2);
        return byteBufAllocator;
    }

    public ByteBuf encodeHeadersFrame(ByteBufAllocator byteBufAllocator, int n, boolean bl, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        bl = bl;
        int n3 = n2 + 4;
        byteBufAllocator = byteBufAllocator.ioBuffer(n3 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 8, (byte)(bl ? 1 : 0), n3);
        byteBufAllocator.writeInt(n);
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        return byteBufAllocator;
    }

    public ByteBuf encodeWindowUpdateFrame(ByteBufAllocator byteBufAllocator, int n, int n2) {
        byteBufAllocator = byteBufAllocator.ioBuffer(16).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, 9, (byte)0, 8);
        byteBufAllocator.writeInt(n);
        byteBufAllocator.writeInt(n2);
        return byteBufAllocator;
    }

    public ByteBuf encodeUnknownFrame(ByteBufAllocator byteBufAllocator, int n, byte by, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        byteBufAllocator = byteBufAllocator.ioBuffer(n2 + 8).order(ByteOrder.BIG_ENDIAN);
        this.writeControlFrameHeader((ByteBuf)byteBufAllocator, n, by, n2);
        if (n2 > 0) {
            ByteBuf byteBuf2 = byteBuf;
            byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        }
        return byteBufAllocator;
    }
}

